package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateBackendJobRequest(
    appId: __string,
    backendEnvironmentName: __string,
    jobId: __string,
    operation: Optional[__string] = Optional.Absent,
    status: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest = {
    import UpdateBackendJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest
      .builder()
      .appId(appId: java.lang.String)
      .backendEnvironmentName(backendEnvironmentName: java.lang.String)
      .jobId(jobId: java.lang.String)
      .optionallyWith(operation.map(value => value: java.lang.String))(
        _.operation
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendJobRequest.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendJobRequest.wrap(buildAwsValue())
}
object UpdateBackendJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.UpdateBackendJobRequest =
      zio.aws.amplifybackend.model.UpdateBackendJobRequest(
        appId,
        backendEnvironmentName,
        jobId,
        operation.map(value => value),
        status.map(value => value)
      )
    def appId: __string
    def backendEnvironmentName: __string
    def jobId: __string
    def operation: Optional[__string]
    def status: Optional[__string]
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getJobId: ZIO[Any, Nothing, __string] = ZIO.succeed(jobId)
    def getOperation: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operation", operation)
    def getStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest
  ) extends zio.aws.amplifybackend.model.UpdateBackendJobRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val backendEnvironmentName: __string =
      impl.backendEnvironmentName(): __string
    override val jobId: __string = impl.jobId(): __string
    override val operation: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operation())
      .map(value => value: __string)
    override val status: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest
  ): zio.aws.amplifybackend.model.UpdateBackendJobRequest.ReadOnly =
    new Wrapper(impl)
}
