package zio.aws.amplifybackend.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.amplifybackend.model.primitives.{__integerMin1Max25, __string}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBackendJobsRequest(
    appId: __string,
    backendEnvironmentName: __string,
    jobId: Optional[__string] = Optional.Absent,
    maxResults: Optional[__integerMin1Max25] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    operation: Optional[__string] = Optional.Absent,
    status: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest = {
    import ListBackendJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest
      .builder()
      .appId(appId: java.lang.String)
      .backendEnvironmentName(backendEnvironmentName: java.lang.String)
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(operation.map(value => value: java.lang.String))(
        _.operation
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.ListBackendJobsRequest.ReadOnly =
    zio.aws.amplifybackend.model.ListBackendJobsRequest.wrap(buildAwsValue())
}
object ListBackendJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.ListBackendJobsRequest =
      zio.aws.amplifybackend.model.ListBackendJobsRequest(
        appId,
        backendEnvironmentName,
        jobId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        operation.map(value => value),
        status.map(value => value)
      )
    def appId: __string
    def backendEnvironmentName: __string
    def jobId: Optional[__string]
    def maxResults: Optional[__integerMin1Max25]
    def nextToken: Optional[__string]
    def operation: Optional[__string]
    def status: Optional[__string]
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getMaxResults: ZIO[Any, AwsError, __integerMin1Max25] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOperation: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operation", operation)
    def getStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest
  ) extends zio.aws.amplifybackend.model.ListBackendJobsRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val backendEnvironmentName: __string =
      impl.backendEnvironmentName(): __string
    override val jobId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => value: __string)
    override val maxResults: Optional[__integerMin1Max25] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => value: __integerMin1Max25)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val operation: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operation())
      .map(value => value: __string)
    override val status: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest
  ): zio.aws.amplifybackend.model.ListBackendJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
