package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBackendStorageResponse(
    appId: Option[__string] = None,
    backendEnvironmentName: Option[__string] = None,
    resourceConfig: Option[
      zio.aws.amplifybackend.model.GetBackendStorageResourceConfig
    ] = None,
    resourceName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResponse = {
    import GetBackendStorageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResponse
      .builder()
      .optionallyWith(appId.map(value => value: java.lang.String))(_.appId)
      .optionallyWith(
        backendEnvironmentName.map(value => value: java.lang.String)
      )(_.backendEnvironmentName)
      .optionallyWith(resourceConfig.map(value => value.buildAwsValue()))(
        _.resourceConfig
      )
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.GetBackendStorageResponse.ReadOnly =
    zio.aws.amplifybackend.model.GetBackendStorageResponse.wrap(buildAwsValue())
}
object GetBackendStorageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetBackendStorageResponse =
      zio.aws.amplifybackend.model.GetBackendStorageResponse(
        appId.map(value => value),
        backendEnvironmentName.map(value => value),
        resourceConfig.map(value => value.asEditable),
        resourceName.map(value => value)
      )
    def appId: Option[__string]
    def backendEnvironmentName: Option[__string]
    def resourceConfig: Option[
      zio.aws.amplifybackend.model.GetBackendStorageResourceConfig.ReadOnly
    ]
    def resourceName: Option[__string]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getBackendEnvironmentName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("backendEnvironmentName", backendEnvironmentName)
    def getResourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.GetBackendStorageResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("resourceConfig", resourceConfig)
    def getResourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("resourceName", resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResponse
  ) extends zio.aws.amplifybackend.model.GetBackendStorageResponse.ReadOnly {
    override val appId: Option[__string] =
      scala.Option(impl.appId()).map(value => value: __string)
    override val backendEnvironmentName: Option[__string] =
      scala.Option(impl.backendEnvironmentName()).map(value => value: __string)
    override val resourceConfig: Option[
      zio.aws.amplifybackend.model.GetBackendStorageResourceConfig.ReadOnly
    ] = scala
      .Option(impl.resourceConfig())
      .map(value =>
        zio.aws.amplifybackend.model.GetBackendStorageResourceConfig.wrap(value)
      )
    override val resourceName: Option[__string] =
      scala.Option(impl.resourceName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResponse
  ): zio.aws.amplifybackend.model.GetBackendStorageResponse.ReadOnly =
    new Wrapper(impl)
}
