package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SmsSettings(smsMessage: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.SmsSettings = {
    import SmsSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.SmsSettings
      .builder()
      .optionallyWith(smsMessage.map(value => value: java.lang.String))(
        _.smsMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.SmsSettings.ReadOnly =
    zio.aws.amplifybackend.model.SmsSettings.wrap(buildAwsValue())
}
object SmsSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.SmsSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.SmsSettings =
      zio.aws.amplifybackend.model.SmsSettings(smsMessage.map(value => value))
    def smsMessage: Option[__string]
    def getSmsMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("smsMessage", smsMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.SmsSettings
  ) extends zio.aws.amplifybackend.model.SmsSettings.ReadOnly {
    override val smsMessage: Option[__string] =
      scala.Option(impl.smsMessage()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.SmsSettings
  ): zio.aws.amplifybackend.model.SmsSettings.ReadOnly = new Wrapper(impl)
}
