package zio.aws.amplifybackend.model
import java.lang.Integer
import zio.aws.amplifybackend.model.primitives.{__integerMin1Max25, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBackendJobsRequest(
    appId: __string,
    backendEnvironmentName: __string,
    jobId: Option[__string] = None,
    maxResults: Option[__integerMin1Max25] = None,
    nextToken: Option[__string] = None,
    operation: Option[__string] = None,
    status: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest = {
    import ListBackendJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest
      .builder()
      .appId(appId: java.lang.String)
      .backendEnvironmentName(backendEnvironmentName: java.lang.String)
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(operation.map(value => value: java.lang.String))(
        _.operation
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.ListBackendJobsRequest.ReadOnly =
    zio.aws.amplifybackend.model.ListBackendJobsRequest.wrap(buildAwsValue())
}
object ListBackendJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.ListBackendJobsRequest =
      zio.aws.amplifybackend.model.ListBackendJobsRequest(
        appId,
        backendEnvironmentName,
        jobId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        operation.map(value => value),
        status.map(value => value)
      )
    def appId: __string
    def backendEnvironmentName: __string
    def jobId: Option[__string]
    def maxResults: Option[__integerMin1Max25]
    def nextToken: Option[__string]
    def operation: Option[__string]
    def status: Option[__string]
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getMaxResults: ZIO[Any, AwsError, __integerMin1Max25] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOperation: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operation", operation)
    def getStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest
  ) extends zio.aws.amplifybackend.model.ListBackendJobsRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val backendEnvironmentName: __string =
      impl.backendEnvironmentName(): __string
    override val jobId: Option[__string] =
      scala.Option(impl.jobId()).map(value => value: __string)
    override val maxResults: Option[__integerMin1Max25] =
      scala.Option(impl.maxResults()).map(value => value: __integerMin1Max25)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val operation: Option[__string] =
      scala.Option(impl.operation()).map(value => value: __string)
    override val status: Option[__string] =
      scala.Option(impl.status()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest
  ): zio.aws.amplifybackend.model.ListBackendJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
