package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters._
sealed trait MFAMode {
  def unwrap: software.amazon.awssdk.services.amplifybackend.model.MFAMode
}
object MFAMode {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.MFAMode
  ): zio.aws.amplifybackend.model.MFAMode = value match {
    case software.amazon.awssdk.services.amplifybackend.model.MFAMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.MFAMode.ON =>
      val r = ON
      r
    case software.amazon.awssdk.services.amplifybackend.model.MFAMode.OFF =>
      val r = OFF
      r
    case software.amazon.awssdk.services.amplifybackend.model.MFAMode.OPTIONAL =>
      val r = OPTIONAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.amplifybackend.model.MFAMode {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.MFAMode =
      software.amazon.awssdk.services.amplifybackend.model.MFAMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ON extends zio.aws.amplifybackend.model.MFAMode {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.MFAMode =
      software.amazon.awssdk.services.amplifybackend.model.MFAMode.ON
  }
  case object OFF extends zio.aws.amplifybackend.model.MFAMode {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.MFAMode =
      software.amazon.awssdk.services.amplifybackend.model.MFAMode.OFF
  }
  case object OPTIONAL extends zio.aws.amplifybackend.model.MFAMode {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.MFAMode =
      software.amazon.awssdk.services.amplifybackend.model.MFAMode.OPTIONAL
  }
}
