package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportBackendAuthRequest(
    appId: __string,
    backendEnvironmentName: __string,
    identityPoolId: Option[__string] = None,
    nativeClientId: __string,
    userPoolId: __string,
    webClientId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest = {
    import ImportBackendAuthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest
      .builder()
      .appId(appId: java.lang.String)
      .backendEnvironmentName(backendEnvironmentName: java.lang.String)
      .optionallyWith(identityPoolId.map(value => value: java.lang.String))(
        _.identityPoolId
      )
      .nativeClientId(nativeClientId: java.lang.String)
      .userPoolId(userPoolId: java.lang.String)
      .webClientId(webClientId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.ImportBackendAuthRequest.ReadOnly =
    zio.aws.amplifybackend.model.ImportBackendAuthRequest.wrap(buildAwsValue())
}
object ImportBackendAuthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.ImportBackendAuthRequest =
      zio.aws.amplifybackend.model.ImportBackendAuthRequest(
        appId,
        backendEnvironmentName,
        identityPoolId.map(value => value),
        nativeClientId,
        userPoolId,
        webClientId
      )
    def appId: __string
    def backendEnvironmentName: __string
    def identityPoolId: Option[__string]
    def nativeClientId: __string
    def userPoolId: __string
    def webClientId: __string
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getIdentityPoolId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getNativeClientId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(nativeClientId)
    def getUserPoolId: ZIO[Any, Nothing, __string] = ZIO.succeed(userPoolId)
    def getWebClientId: ZIO[Any, Nothing, __string] = ZIO.succeed(webClientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest
  ) extends zio.aws.amplifybackend.model.ImportBackendAuthRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val backendEnvironmentName: __string =
      impl.backendEnvironmentName(): __string
    override val identityPoolId: Option[__string] =
      scala.Option(impl.identityPoolId()).map(value => value: __string)
    override val nativeClientId: __string = impl.nativeClientId(): __string
    override val userPoolId: __string = impl.userPoolId(): __string
    override val webClientId: __string = impl.webClientId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest
  ): zio.aws.amplifybackend.model.ImportBackendAuthRequest.ReadOnly =
    new Wrapper(impl)
}
