package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__double
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBackendAuthPasswordPolicyConfig(
    additionalConstraints: Option[
      Iterable[zio.aws.amplifybackend.model.AdditionalConstraintsElement]
    ] = None,
    minimumLength: __double
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig = {
    import CreateBackendAuthPasswordPolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig
      .builder()
      .optionallyWith(
        additionalConstraints.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.additionalConstraintsWithStrings)
      .minimumLength(minimumLength: java.lang.Double)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig
      .wrap(buildAwsValue())
}
object CreateBackendAuthPasswordPolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig =
      zio.aws.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig(
        additionalConstraints.map(value => value),
        minimumLength
      )
    def additionalConstraints: Option[
      List[zio.aws.amplifybackend.model.AdditionalConstraintsElement]
    ]
    def minimumLength: __double
    def getAdditionalConstraints: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.AdditionalConstraintsElement
    ]] =
      AwsError.unwrapOptionField("additionalConstraints", additionalConstraints)
    def getMinimumLength: ZIO[Any, Nothing, __double] =
      ZIO.succeed(minimumLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig
  ) extends zio.aws.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig.ReadOnly {
    override val additionalConstraints: Option[
      List[zio.aws.amplifybackend.model.AdditionalConstraintsElement]
    ] = scala
      .Option(impl.additionalConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifybackend.model.AdditionalConstraintsElement.wrap(item)
        }.toList
      )
    override val minimumLength: __double = impl.minimumLength(): __double
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig
  ): zio.aws.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig.ReadOnly =
    new Wrapper(impl)
}
