package zio.aws.amplifybackend
import zio.aws.amplifybackend.model.DeleteTokenResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.amplifybackend.model.{
  ListS3BucketsRequest,
  GetBackendApiRequest,
  ImportBackendAuthRequest,
  UpdateBackendJobRequest,
  UpdateBackendAuthRequest,
  GetBackendJobRequest,
  GetBackendAuthRequest,
  GetBackendStorageRequest,
  UpdateBackendStorageRequest,
  DeleteTokenRequest,
  UpdateBackendApiRequest,
  DeleteBackendRequest,
  DeleteBackendStorageRequest,
  CreateBackendAuthRequest,
  DeleteBackendAuthRequest,
  CreateBackendStorageRequest,
  CreateTokenRequest,
  RemoveAllBackendsRequest,
  GetBackendApiModelsRequest,
  GetTokenRequest,
  ListBackendJobsRequest,
  RemoveBackendConfigRequest,
  DeleteBackendApiRequest,
  UpdateBackendConfigRequest,
  CloneBackendRequest,
  ImportBackendStorageRequest,
  CreateBackendConfigRequest,
  GenerateBackendApiModelsRequest,
  CreateBackendApiRequest,
  GetBackendRequest,
  CreateBackendRequest
}
import software.amazon.awssdk.services.amplifybackend.{
  AmplifyBackendAsyncClientBuilder,
  AmplifyBackendAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.amplifybackend.model.{
  DeleteBackendAuthResponse,
  ImportBackendAuthResponse,
  DeleteTokenResponse,
  RemoveAllBackendsResponse,
  GetBackendStorageResponse,
  S3BucketInfo,
  GetBackendApiResponse,
  UpdateBackendConfigResponse,
  ListS3BucketsResponse,
  UpdateBackendJobResponse,
  GetBackendResponse,
  CreateBackendConfigResponse,
  DeleteBackendResponse,
  DeleteBackendApiResponse,
  UpdateBackendAuthResponse,
  UpdateBackendStorageResponse,
  GenerateBackendApiModelsResponse,
  GetBackendJobResponse,
  GetBackendAuthResponse,
  RemoveBackendConfigResponse,
  ListBackendJobsResponse,
  GetTokenResponse,
  DeleteBackendStorageResponse,
  ImportBackendStorageResponse,
  BackendJobRespObj,
  CloneBackendResponse,
  CreateBackendResponse,
  CreateBackendStorageResponse,
  UpdateBackendApiResponse,
  CreateBackendApiResponse,
  CreateBackendAuthResponse,
  CreateTokenResponse,
  GetBackendApiModelsResponse
}
import scala.jdk.CollectionConverters._
trait AmplifyBackend extends AspectSupport[AmplifyBackend] {
  val api: AmplifyBackendAsyncClient
  def getToken(
      request: GetTokenRequest
  ): IO[AwsError, zio.aws.amplifybackend.model.GetTokenResponse.ReadOnly]
  def getBackendAuth(
      request: GetBackendAuthRequest
  ): IO[AwsError, zio.aws.amplifybackend.model.GetBackendAuthResponse.ReadOnly]
  def createToken(
      request: CreateTokenRequest
  ): IO[AwsError, zio.aws.amplifybackend.model.CreateTokenResponse.ReadOnly]
  def getBackendAPIModels(request: GetBackendApiModelsRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.GetBackendApiModelsResponse.ReadOnly
  ]
  def updateBackendAuth(request: UpdateBackendAuthRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.UpdateBackendAuthResponse.ReadOnly
  ]
  def createBackendStorage(request: CreateBackendStorageRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.CreateBackendStorageResponse.ReadOnly
  ]
  def deleteToken(request: DeleteTokenRequest): IO[AwsError, ReadOnly]
  def updateBackendJob(request: UpdateBackendJobRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.UpdateBackendJobResponse.ReadOnly
  ]
  def deleteBackendAPI(request: DeleteBackendApiRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.DeleteBackendApiResponse.ReadOnly
  ]
  def updateBackendConfig(request: UpdateBackendConfigRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.UpdateBackendConfigResponse.ReadOnly
  ]
  def getBackend(
      request: GetBackendRequest
  ): IO[AwsError, zio.aws.amplifybackend.model.GetBackendResponse.ReadOnly]
  def updateBackendStorage(request: UpdateBackendStorageRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.UpdateBackendStorageResponse.ReadOnly
  ]
  def importBackendStorage(request: ImportBackendStorageRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.ImportBackendStorageResponse.ReadOnly
  ]
  def getBackendJob(
      request: GetBackendJobRequest
  ): IO[AwsError, zio.aws.amplifybackend.model.GetBackendJobResponse.ReadOnly]
  def listS3Buckets(
      request: ListS3BucketsRequest
  ): ZStream[Any, AwsError, zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly]
  def listS3BucketsPaginated(
      request: ListS3BucketsRequest
  ): IO[AwsError, zio.aws.amplifybackend.model.ListS3BucketsResponse.ReadOnly]
  def generateBackendAPIModels(request: GenerateBackendApiModelsRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.GenerateBackendApiModelsResponse.ReadOnly
  ]
  def listBackendJobs(request: ListBackendJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.amplifybackend.model.BackendJobRespObj.ReadOnly
  ]
  def listBackendJobsPaginated(
      request: ListBackendJobsRequest
  ): IO[AwsError, zio.aws.amplifybackend.model.ListBackendJobsResponse.ReadOnly]
  def createBackend(
      request: CreateBackendRequest
  ): IO[AwsError, zio.aws.amplifybackend.model.CreateBackendResponse.ReadOnly]
  def removeBackendConfig(request: RemoveBackendConfigRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.RemoveBackendConfigResponse.ReadOnly
  ]
  def updateBackendAPI(request: UpdateBackendApiRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.UpdateBackendApiResponse.ReadOnly
  ]
  def deleteBackendStorage(request: DeleteBackendStorageRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.DeleteBackendStorageResponse.ReadOnly
  ]
  def deleteBackend(
      request: DeleteBackendRequest
  ): IO[AwsError, zio.aws.amplifybackend.model.DeleteBackendResponse.ReadOnly]
  def getBackendStorage(request: GetBackendStorageRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.GetBackendStorageResponse.ReadOnly
  ]
  def removeAllBackends(request: RemoveAllBackendsRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.RemoveAllBackendsResponse.ReadOnly
  ]
  def deleteBackendAuth(request: DeleteBackendAuthRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.DeleteBackendAuthResponse.ReadOnly
  ]
  def importBackendAuth(request: ImportBackendAuthRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.ImportBackendAuthResponse.ReadOnly
  ]
  def cloneBackend(
      request: CloneBackendRequest
  ): IO[AwsError, zio.aws.amplifybackend.model.CloneBackendResponse.ReadOnly]
  def createBackendAuth(request: CreateBackendAuthRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.CreateBackendAuthResponse.ReadOnly
  ]
  def createBackendConfig(request: CreateBackendConfigRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.CreateBackendConfigResponse.ReadOnly
  ]
  def getBackendAPI(
      request: GetBackendApiRequest
  ): IO[AwsError, zio.aws.amplifybackend.model.GetBackendApiResponse.ReadOnly]
  def createBackendAPI(request: CreateBackendApiRequest): IO[
    AwsError,
    zio.aws.amplifybackend.model.CreateBackendApiResponse.ReadOnly
  ]
}
object AmplifyBackend {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AmplifyBackend] = customized(
    identity
  )
  def customized(
      customization: AmplifyBackendAsyncClientBuilder => AmplifyBackendAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AmplifyBackend] = managed(
    customization
  ).toLayer
  def managed(
      customization: AmplifyBackendAsyncClientBuilder => AmplifyBackendAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, AmplifyBackend] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = AmplifyBackendAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[AmplifyBackendAsyncClient, AmplifyBackendAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        AmplifyBackendAsyncClient,
        AmplifyBackendAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new AmplifyBackendImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class AmplifyBackendImpl[R](
      override val api: AmplifyBackendAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AmplifyBackend
      with AwsServiceBase[R] {
    override val serviceName: String = "AmplifyBackend"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AmplifyBackendImpl[R1] = new AmplifyBackendImpl(api, newAspect, r)
    def getToken(
        request: GetTokenRequest
    ): IO[AwsError, zio.aws.amplifybackend.model.GetTokenResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.amplifybackend.model.GetTokenRequest,
        GetTokenResponse
      ]("getToken", api.getToken)(request.buildAwsValue())
        .map(zio.aws.amplifybackend.model.GetTokenResponse.wrap)
        .provideEnvironment(r)
    def getBackendAuth(request: GetBackendAuthRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.GetBackendAuthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthRequest,
      GetBackendAuthResponse
    ]("getBackendAuth", api.getBackendAuth)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.GetBackendAuthResponse.wrap)
      .provideEnvironment(r)
    def createToken(
        request: CreateTokenRequest
    ): IO[AwsError, zio.aws.amplifybackend.model.CreateTokenResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.amplifybackend.model.CreateTokenRequest,
        CreateTokenResponse
      ]("createToken", api.createToken)(request.buildAwsValue())
        .map(zio.aws.amplifybackend.model.CreateTokenResponse.wrap)
        .provideEnvironment(r)
    def getBackendAPIModels(request: GetBackendApiModelsRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.GetBackendApiModelsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsRequest,
      GetBackendApiModelsResponse
    ]("getBackendAPIModels", api.getBackendAPIModels)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.GetBackendApiModelsResponse.wrap)
      .provideEnvironment(r)
    def updateBackendAuth(request: UpdateBackendAuthRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.UpdateBackendAuthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthRequest,
      UpdateBackendAuthResponse
    ]("updateBackendAuth", api.updateBackendAuth)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.UpdateBackendAuthResponse.wrap)
      .provideEnvironment(r)
    def createBackendStorage(request: CreateBackendStorageRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendStorageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageRequest,
      CreateBackendStorageResponse
    ]("createBackendStorage", api.createBackendStorage)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.CreateBackendStorageResponse.wrap)
      .provideEnvironment(r)
    def deleteToken(request: DeleteTokenRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.amplifybackend.model.DeleteTokenRequest,
        DeleteTokenResponse
      ]("deleteToken", api.deleteToken)(request.buildAwsValue())
        .map(zio.aws.amplifybackend.model.DeleteTokenResponse.wrap)
        .provideEnvironment(r)
    def updateBackendJob(request: UpdateBackendJobRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.UpdateBackendJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest,
      UpdateBackendJobResponse
    ]("updateBackendJob", api.updateBackendJob)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.UpdateBackendJobResponse.wrap)
      .provideEnvironment(r)
    def deleteBackendAPI(request: DeleteBackendApiRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.DeleteBackendApiResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.DeleteBackendApiRequest,
      DeleteBackendApiResponse
    ]("deleteBackendAPI", api.deleteBackendAPI)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.DeleteBackendApiResponse.wrap)
      .provideEnvironment(r)
    def updateBackendConfig(request: UpdateBackendConfigRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.UpdateBackendConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigRequest,
      UpdateBackendConfigResponse
    ]("updateBackendConfig", api.updateBackendConfig)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.UpdateBackendConfigResponse.wrap)
      .provideEnvironment(r)
    def getBackend(
        request: GetBackendRequest
    ): IO[AwsError, zio.aws.amplifybackend.model.GetBackendResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.amplifybackend.model.GetBackendRequest,
        GetBackendResponse
      ]("getBackend", api.getBackend)(request.buildAwsValue())
        .map(zio.aws.amplifybackend.model.GetBackendResponse.wrap)
        .provideEnvironment(r)
    def updateBackendStorage(request: UpdateBackendStorageRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.UpdateBackendStorageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageRequest,
      UpdateBackendStorageResponse
    ]("updateBackendStorage", api.updateBackendStorage)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.UpdateBackendStorageResponse.wrap)
      .provideEnvironment(r)
    def importBackendStorage(request: ImportBackendStorageRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.ImportBackendStorageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageRequest,
      ImportBackendStorageResponse
    ]("importBackendStorage", api.importBackendStorage)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.ImportBackendStorageResponse.wrap)
      .provideEnvironment(r)
    def getBackendJob(request: GetBackendJobRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.GetBackendJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.GetBackendJobRequest,
      GetBackendJobResponse
    ]("getBackendJob", api.getBackendJob)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.GetBackendJobResponse.wrap)
      .provideEnvironment(r)
    def listS3Buckets(request: ListS3BucketsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsRequest,
      ListS3BucketsResponse,
      S3BucketInfo
    ](
      "listS3Buckets",
      api.listS3Buckets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.buckets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.amplifybackend.model.S3BucketInfo.wrap(item))
      .provideEnvironment(r)
    def listS3BucketsPaginated(request: ListS3BucketsRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.ListS3BucketsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsRequest,
      ListS3BucketsResponse
    ]("listS3Buckets", api.listS3Buckets)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.ListS3BucketsResponse.wrap)
      .provideEnvironment(r)
    def generateBackendAPIModels(request: GenerateBackendApiModelsRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.GenerateBackendApiModelsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.GenerateBackendApiModelsRequest,
      GenerateBackendApiModelsResponse
    ]("generateBackendAPIModels", api.generateBackendAPIModels)(
      request.buildAwsValue()
    ).map(zio.aws.amplifybackend.model.GenerateBackendApiModelsResponse.wrap)
      .provideEnvironment(r)
    def listBackendJobs(request: ListBackendJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendJobRespObj.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest,
      ListBackendJobsResponse,
      BackendJobRespObj
    ](
      "listBackendJobs",
      api.listBackendJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.jobs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.amplifybackend.model.BackendJobRespObj.wrap(item))
      .provideEnvironment(r)
    def listBackendJobsPaginated(request: ListBackendJobsRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.ListBackendJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest,
      ListBackendJobsResponse
    ]("listBackendJobs", api.listBackendJobs)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.ListBackendJobsResponse.wrap)
      .provideEnvironment(r)
    def createBackend(request: CreateBackendRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.CreateBackendRequest,
      CreateBackendResponse
    ]("createBackend", api.createBackend)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.CreateBackendResponse.wrap)
      .provideEnvironment(r)
    def removeBackendConfig(request: RemoveBackendConfigRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.RemoveBackendConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.RemoveBackendConfigRequest,
      RemoveBackendConfigResponse
    ]("removeBackendConfig", api.removeBackendConfig)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.RemoveBackendConfigResponse.wrap)
      .provideEnvironment(r)
    def updateBackendAPI(request: UpdateBackendApiRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.UpdateBackendApiResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiRequest,
      UpdateBackendApiResponse
    ]("updateBackendAPI", api.updateBackendAPI)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.UpdateBackendApiResponse.wrap)
      .provideEnvironment(r)
    def deleteBackendStorage(request: DeleteBackendStorageRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.DeleteBackendStorageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageRequest,
      DeleteBackendStorageResponse
    ]("deleteBackendStorage", api.deleteBackendStorage)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.DeleteBackendStorageResponse.wrap)
      .provideEnvironment(r)
    def deleteBackend(request: DeleteBackendRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.DeleteBackendResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.DeleteBackendRequest,
      DeleteBackendResponse
    ]("deleteBackend", api.deleteBackend)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.DeleteBackendResponse.wrap)
      .provideEnvironment(r)
    def getBackendStorage(request: GetBackendStorageRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.GetBackendStorageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageRequest,
      GetBackendStorageResponse
    ]("getBackendStorage", api.getBackendStorage)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.GetBackendStorageResponse.wrap)
      .provideEnvironment(r)
    def removeAllBackends(request: RemoveAllBackendsRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.RemoveAllBackendsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest,
      RemoveAllBackendsResponse
    ]("removeAllBackends", api.removeAllBackends)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.RemoveAllBackendsResponse.wrap)
      .provideEnvironment(r)
    def deleteBackendAuth(request: DeleteBackendAuthRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.DeleteBackendAuthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.DeleteBackendAuthRequest,
      DeleteBackendAuthResponse
    ]("deleteBackendAuth", api.deleteBackendAuth)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.DeleteBackendAuthResponse.wrap)
      .provideEnvironment(r)
    def importBackendAuth(request: ImportBackendAuthRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.ImportBackendAuthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest,
      ImportBackendAuthResponse
    ]("importBackendAuth", api.importBackendAuth)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.ImportBackendAuthResponse.wrap)
      .provideEnvironment(r)
    def cloneBackend(request: CloneBackendRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.CloneBackendResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.CloneBackendRequest,
      CloneBackendResponse
    ]("cloneBackend", api.cloneBackend)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.CloneBackendResponse.wrap)
      .provideEnvironment(r)
    def createBackendAuth(request: CreateBackendAuthRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendAuthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthRequest,
      CreateBackendAuthResponse
    ]("createBackendAuth", api.createBackendAuth)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.CreateBackendAuthResponse.wrap)
      .provideEnvironment(r)
    def createBackendConfig(request: CreateBackendConfigRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigRequest,
      CreateBackendConfigResponse
    ]("createBackendConfig", api.createBackendConfig)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.CreateBackendConfigResponse.wrap)
      .provideEnvironment(r)
    def getBackendAPI(request: GetBackendApiRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.GetBackendApiResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.GetBackendApiRequest,
      GetBackendApiResponse
    ]("getBackendAPI", api.getBackendAPI)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.GetBackendApiResponse.wrap)
      .provideEnvironment(r)
    def createBackendAPI(request: CreateBackendApiRequest): IO[
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendApiResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiRequest,
      CreateBackendApiResponse
    ]("createBackendAPI", api.createBackendAPI)(request.buildAwsValue())
      .map(zio.aws.amplifybackend.model.CreateBackendApiResponse.wrap)
      .provideEnvironment(r)
  }
  def getToken(request: GetTokenRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.GetTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getToken(request))
  def getBackendAuth(request: GetBackendAuthRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.GetBackendAuthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackendAuth(request))
  def createToken(request: CreateTokenRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.CreateTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createToken(request))
  def getBackendAPIModels(request: GetBackendApiModelsRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.GetBackendApiModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackendAPIModels(request))
  def updateBackendAuth(request: UpdateBackendAuthRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.UpdateBackendAuthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBackendAuth(request))
  def createBackendStorage(request: CreateBackendStorageRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.CreateBackendStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBackendStorage(request))
  def deleteToken(
      request: DeleteTokenRequest
  ): ZIO[zio.aws.amplifybackend.AmplifyBackend, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteToken(request))
  def updateBackendJob(request: UpdateBackendJobRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.UpdateBackendJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBackendJob(request))
  def deleteBackendAPI(request: DeleteBackendApiRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.DeleteBackendApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBackendAPI(request))
  def updateBackendConfig(request: UpdateBackendConfigRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.UpdateBackendConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBackendConfig(request))
  def getBackend(request: GetBackendRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.GetBackendResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackend(request))
  def updateBackendStorage(request: UpdateBackendStorageRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.UpdateBackendStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBackendStorage(request))
  def importBackendStorage(request: ImportBackendStorageRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.ImportBackendStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importBackendStorage(request))
  def getBackendJob(request: GetBackendJobRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.GetBackendJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackendJob(request))
  def listS3Buckets(request: ListS3BucketsRequest): ZStream[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listS3Buckets(request))
  def listS3BucketsPaginated(request: ListS3BucketsRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.ListS3BucketsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listS3BucketsPaginated(request))
  def generateBackendAPIModels(request: GenerateBackendApiModelsRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.GenerateBackendApiModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateBackendAPIModels(request))
  def listBackendJobs(request: ListBackendJobsRequest): ZStream[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.BackendJobRespObj.ReadOnly
  ] = ZStream.serviceWithStream(_.listBackendJobs(request))
  def listBackendJobsPaginated(request: ListBackendJobsRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.ListBackendJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBackendJobsPaginated(request))
  def createBackend(request: CreateBackendRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.CreateBackendResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBackend(request))
  def removeBackendConfig(request: RemoveBackendConfigRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.RemoveBackendConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeBackendConfig(request))
  def updateBackendAPI(request: UpdateBackendApiRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.UpdateBackendApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBackendAPI(request))
  def deleteBackendStorage(request: DeleteBackendStorageRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.DeleteBackendStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBackendStorage(request))
  def deleteBackend(request: DeleteBackendRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.DeleteBackendResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBackend(request))
  def getBackendStorage(request: GetBackendStorageRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.GetBackendStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackendStorage(request))
  def removeAllBackends(request: RemoveAllBackendsRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.RemoveAllBackendsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeAllBackends(request))
  def deleteBackendAuth(request: DeleteBackendAuthRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.DeleteBackendAuthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBackendAuth(request))
  def importBackendAuth(request: ImportBackendAuthRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.ImportBackendAuthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importBackendAuth(request))
  def cloneBackend(request: CloneBackendRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.CloneBackendResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cloneBackend(request))
  def createBackendAuth(request: CreateBackendAuthRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.CreateBackendAuthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBackendAuth(request))
  def createBackendConfig(request: CreateBackendConfigRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.CreateBackendConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBackendConfig(request))
  def getBackendAPI(request: GetBackendApiRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.GetBackendApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackendAPI(request))
  def createBackendAPI(request: CreateBackendApiRequest): ZIO[
    zio.aws.amplifybackend.AmplifyBackend,
    AwsError,
    zio.aws.amplifybackend.model.CreateBackendApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBackendAPI(request))
}
