package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateBackendConfigRequest(
    appId: __string,
    loginAuthConfig: Option[
      zio.aws.amplifybackend.model.LoginAuthConfigReqObj
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigRequest = {
    import UpdateBackendConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigRequest
      .builder()
      .appId(appId: java.lang.String)
      .optionallyWith(loginAuthConfig.map(value => value.buildAwsValue()))(
        _.loginAuthConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendConfigRequest.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendConfigRequest
      .wrap(buildAwsValue())
}
object UpdateBackendConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.UpdateBackendConfigRequest =
      zio.aws.amplifybackend.model.UpdateBackendConfigRequest(
        appId,
        loginAuthConfig.map(value => value.asEditable)
      )
    def appId: __string
    def loginAuthConfig
        : Option[zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly]
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getLoginAuthConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly
    ] = AwsError.unwrapOptionField("loginAuthConfig", loginAuthConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigRequest
  ) extends zio.aws.amplifybackend.model.UpdateBackendConfigRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val loginAuthConfig
        : Option[zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly] =
      scala
        .Option(impl.loginAuthConfig())
        .map(value =>
          zio.aws.amplifybackend.model.LoginAuthConfigReqObj.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigRequest
  ): zio.aws.amplifybackend.model.UpdateBackendConfigRequest.ReadOnly =
    new Wrapper(impl)
}
