package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloneBackendRequest(
    appId: __string,
    backendEnvironmentName: __string,
    targetEnvironmentName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CloneBackendRequest = {
    import CloneBackendRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CloneBackendRequest
      .builder()
      .appId(appId: java.lang.String)
      .backendEnvironmentName(backendEnvironmentName: java.lang.String)
      .targetEnvironmentName(targetEnvironmentName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.CloneBackendRequest.ReadOnly =
    zio.aws.amplifybackend.model.CloneBackendRequest.wrap(buildAwsValue())
}
object CloneBackendRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CloneBackendRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.CloneBackendRequest =
      zio.aws.amplifybackend.model.CloneBackendRequest(
        appId,
        backendEnvironmentName,
        targetEnvironmentName
      )
    def appId: __string
    def backendEnvironmentName: __string
    def targetEnvironmentName: __string
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getTargetEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(targetEnvironmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CloneBackendRequest
  ) extends zio.aws.amplifybackend.model.CloneBackendRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val backendEnvironmentName: __string =
      impl.backendEnvironmentName(): __string
    override val targetEnvironmentName: __string =
      impl.targetEnvironmentName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CloneBackendRequest
  ): zio.aws.amplifybackend.model.CloneBackendRequest.ReadOnly = new Wrapper(
    impl
  )
}
