package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BackendAPIResourceConfig(
    additionalAuthTypes: Option[
      Iterable[zio.aws.amplifybackend.model.BackendAPIAuthType]
    ] = None,
    apiName: Option[__string] = None,
    conflictResolution: Option[
      zio.aws.amplifybackend.model.BackendAPIConflictResolution
    ] = None,
    defaultAuthType: Option[zio.aws.amplifybackend.model.BackendAPIAuthType] =
      None,
    service: Option[__string] = None,
    transformSchema: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig = {
    import BackendAPIResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig
      .builder()
      .optionallyWith(
        additionalAuthTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAuthTypes)
      .optionallyWith(apiName.map(value => value: java.lang.String))(_.apiName)
      .optionallyWith(conflictResolution.map(value => value.buildAwsValue()))(
        _.conflictResolution
      )
      .optionallyWith(defaultAuthType.map(value => value.buildAwsValue()))(
        _.defaultAuthType
      )
      .optionallyWith(service.map(value => value: java.lang.String))(_.service)
      .optionallyWith(transformSchema.map(value => value: java.lang.String))(
        _.transformSchema
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly =
    zio.aws.amplifybackend.model.BackendAPIResourceConfig.wrap(buildAwsValue())
}
object BackendAPIResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.BackendAPIResourceConfig =
      zio.aws.amplifybackend.model.BackendAPIResourceConfig(
        additionalAuthTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        apiName.map(value => value),
        conflictResolution.map(value => value.asEditable),
        defaultAuthType.map(value => value.asEditable),
        service.map(value => value),
        transformSchema.map(value => value)
      )
    def additionalAuthTypes
        : Option[List[zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly]]
    def apiName: Option[__string]
    def conflictResolution: Option[
      zio.aws.amplifybackend.model.BackendAPIConflictResolution.ReadOnly
    ]
    def defaultAuthType
        : Option[zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly]
    def service: Option[__string]
    def transformSchema: Option[__string]
    def getAdditionalAuthTypes: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly
    ]] = AwsError.unwrapOptionField("additionalAuthTypes", additionalAuthTypes)
    def getApiName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiName", apiName)
    def getConflictResolution: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAPIConflictResolution.ReadOnly
    ] = AwsError.unwrapOptionField("conflictResolution", conflictResolution)
    def getDefaultAuthType: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly
    ] = AwsError.unwrapOptionField("defaultAuthType", defaultAuthType)
    def getService: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("service", service)
    def getTransformSchema: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("transformSchema", transformSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig
  ) extends zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly {
    override val additionalAuthTypes: Option[
      List[zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly]
    ] = scala
      .Option(impl.additionalAuthTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifybackend.model.BackendAPIAuthType.wrap(item)
        }.toList
      )
    override val apiName: Option[__string] =
      scala.Option(impl.apiName()).map(value => value: __string)
    override val conflictResolution: Option[
      zio.aws.amplifybackend.model.BackendAPIConflictResolution.ReadOnly
    ] = scala
      .Option(impl.conflictResolution())
      .map(value =>
        zio.aws.amplifybackend.model.BackendAPIConflictResolution.wrap(value)
      )
    override val defaultAuthType
        : Option[zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly] =
      scala
        .Option(impl.defaultAuthType())
        .map(value =>
          zio.aws.amplifybackend.model.BackendAPIAuthType.wrap(value)
        )
    override val service: Option[__string] =
      scala.Option(impl.service()).map(value => value: __string)
    override val transformSchema: Option[__string] =
      scala.Option(impl.transformSchema()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig
  ): zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly =
    new Wrapper(impl)
}
