package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateBackendAuthOAuthConfig(
    domainPrefix: Option[__string] = None,
    oAuthGrantType: Option[zio.aws.amplifybackend.model.OAuthGrantType] = None,
    oAuthScopes: Option[
      Iterable[zio.aws.amplifybackend.model.OAuthScopesElement]
    ] = None,
    redirectSignInURIs: Option[Iterable[__string]] = None,
    redirectSignOutURIs: Option[Iterable[__string]] = None,
    socialProviderSettings: Option[
      zio.aws.amplifybackend.model.SocialProviderSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthOAuthConfig = {
    import UpdateBackendAuthOAuthConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthOAuthConfig
      .builder()
      .optionallyWith(
        domainPrefix.map(value => __string.unwrap(value): java.lang.String)
      )(_.domainPrefix)
      .optionallyWith(oAuthGrantType.map(value => value.unwrap))(
        _.oAuthGrantType
      )
      .optionallyWith(
        oAuthScopes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.oAuthScopesWithStrings)
      .optionallyWith(
        redirectSignInURIs.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.redirectSignInURIs)
      .optionallyWith(
        redirectSignOutURIs.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.redirectSignOutURIs)
      .optionallyWith(
        socialProviderSettings.map(value => value.buildAwsValue())
      )(_.socialProviderSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig
      .wrap(buildAwsValue())
}
object UpdateBackendAuthOAuthConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthOAuthConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig =
      zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig(
        domainPrefix.map(value => value),
        oAuthGrantType.map(value => value),
        oAuthScopes.map(value => value),
        redirectSignInURIs.map(value => value),
        redirectSignOutURIs.map(value => value),
        socialProviderSettings.map(value => value.asEditable)
      )
    def domainPrefix: Option[__string]
    def oAuthGrantType: Option[zio.aws.amplifybackend.model.OAuthGrantType]
    def oAuthScopes
        : Option[List[zio.aws.amplifybackend.model.OAuthScopesElement]]
    def redirectSignInURIs: Option[List[__string]]
    def redirectSignOutURIs: Option[List[__string]]
    def socialProviderSettings
        : Option[zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly]
    def getDomainPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("domainPrefix", domainPrefix)
    def getOAuthGrantType
        : ZIO[Any, AwsError, zio.aws.amplifybackend.model.OAuthGrantType] =
      AwsError.unwrapOptionField("oAuthGrantType", oAuthGrantType)
    def getOAuthScopes: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.OAuthScopesElement
    ]] = AwsError.unwrapOptionField("oAuthScopes", oAuthScopes)
    def getRedirectSignInURIs: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("redirectSignInURIs", redirectSignInURIs)
    def getRedirectSignOutURIs: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("redirectSignOutURIs", redirectSignOutURIs)
    def getSocialProviderSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "socialProviderSettings",
      socialProviderSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthOAuthConfig
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig.ReadOnly {
    override val domainPrefix: Option[__string] = scala
      .Option(impl.domainPrefix())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val oAuthGrantType
        : Option[zio.aws.amplifybackend.model.OAuthGrantType] = scala
      .Option(impl.oAuthGrantType())
      .map(value => zio.aws.amplifybackend.model.OAuthGrantType.wrap(value))
    override val oAuthScopes
        : Option[List[zio.aws.amplifybackend.model.OAuthScopesElement]] = scala
      .Option(impl.oAuthScopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifybackend.model.OAuthScopesElement.wrap(item)
        }.toList
      )
    override val redirectSignInURIs: Option[List[__string]] = scala
      .Option(impl.redirectSignInURIs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifybackend.model.primitives.__string(item)
        }.toList
      )
    override val redirectSignOutURIs: Option[List[__string]] = scala
      .Option(impl.redirectSignOutURIs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifybackend.model.primitives.__string(item)
        }.toList
      )
    override val socialProviderSettings
        : Option[zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly] =
      scala
        .Option(impl.socialProviderSettings())
        .map(value =>
          zio.aws.amplifybackend.model.SocialProviderSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthOAuthConfig
  ): zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig.ReadOnly =
    new Wrapper(impl)
}
