package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBackendApiRequest(
    appId: __string,
    backendEnvironmentName: __string,
    resourceConfig: Option[
      zio.aws.amplifybackend.model.BackendAPIResourceConfig
    ] = None,
    resourceName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetBackendApiRequest = {
    import GetBackendApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetBackendApiRequest
      .builder()
      .appId(__string.unwrap(appId): java.lang.String)
      .backendEnvironmentName(
        __string.unwrap(backendEnvironmentName): java.lang.String
      )
      .optionallyWith(resourceConfig.map(value => value.buildAwsValue()))(
        _.resourceConfig
      )
      .resourceName(__string.unwrap(resourceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.GetBackendApiRequest.ReadOnly =
    zio.aws.amplifybackend.model.GetBackendApiRequest.wrap(buildAwsValue())
}
object GetBackendApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetBackendApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetBackendApiRequest =
      zio.aws.amplifybackend.model.GetBackendApiRequest(
        appId,
        backendEnvironmentName,
        resourceConfig.map(value => value.asEditable),
        resourceName
      )
    def appId: __string
    def backendEnvironmentName: __string
    def resourceConfig
        : Option[zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly]
    def resourceName: __string
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getResourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("resourceConfig", resourceConfig)
    def getResourceName: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendApiRequest
  ) extends zio.aws.amplifybackend.model.GetBackendApiRequest.ReadOnly {
    override val appId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.appId())
    override val backendEnvironmentName: __string =
      zio.aws.amplifybackend.model.primitives
        .__string(impl.backendEnvironmentName())
    override val resourceConfig: Option[
      zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly
    ] = scala
      .Option(impl.resourceConfig())
      .map(value =>
        zio.aws.amplifybackend.model.BackendAPIResourceConfig.wrap(value)
      )
    override val resourceName: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.resourceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendApiRequest
  ): zio.aws.amplifybackend.model.GetBackendApiRequest.ReadOnly = new Wrapper(
    impl
  )
}
