package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBackendConfigResponse(
    appId: Option[__string] = None,
    backendEnvironmentName: Option[__string] = None,
    jobId: Option[__string] = None,
    status: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigResponse = {
    import CreateBackendConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigResponse
      .builder()
      .optionallyWith(
        appId.map(value => __string.unwrap(value): java.lang.String)
      )(_.appId)
      .optionallyWith(
        backendEnvironmentName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.backendEnvironmentName)
      .optionallyWith(
        jobId.map(value => __string.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        status.map(value => __string.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendConfigResponse.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendConfigResponse
      .wrap(buildAwsValue())
}
object CreateBackendConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.CreateBackendConfigResponse =
      zio.aws.amplifybackend.model.CreateBackendConfigResponse(
        appId.map(value => value),
        backendEnvironmentName.map(value => value),
        jobId.map(value => value),
        status.map(value => value)
      )
    def appId: Option[__string]
    def backendEnvironmentName: Option[__string]
    def jobId: Option[__string]
    def status: Option[__string]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getBackendEnvironmentName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("backendEnvironmentName", backendEnvironmentName)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigResponse
  ) extends zio.aws.amplifybackend.model.CreateBackendConfigResponse.ReadOnly {
    override val appId: Option[__string] = scala
      .Option(impl.appId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val backendEnvironmentName: Option[__string] = scala
      .Option(impl.backendEnvironmentName())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val jobId: Option[__string] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val status: Option[__string] = scala
      .Option(impl.status())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigResponse
  ): zio.aws.amplifybackend.model.CreateBackendConfigResponse.ReadOnly =
    new Wrapper(impl)
}
