package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__boolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateBackendAuthIdentityPoolConfig(
    unauthenticatedLogin: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig = {
    import UpdateBackendAuthIdentityPoolConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig
      .builder()
      .optionallyWith(
        unauthenticatedLogin.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.unauthenticatedLogin)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig
      .wrap(buildAwsValue())
}
object UpdateBackendAuthIdentityPoolConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig =
      zio.aws.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig(
        unauthenticatedLogin.map(value => value)
      )
    def unauthenticatedLogin: Option[__boolean]
    def getUnauthenticatedLogin: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("unauthenticatedLogin", unauthenticatedLogin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig.ReadOnly {
    override val unauthenticatedLogin: Option[__boolean] = scala
      .Option(impl.unauthenticatedLogin())
      .map(value => zio.aws.amplifybackend.model.primitives.__boolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig
  ): zio.aws.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig.ReadOnly =
    new Wrapper(impl)
}
