package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BackendAuthSocialProviderConfig(
    clientId: Option[__string] = None,
    clientSecret: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendAuthSocialProviderConfig = {
    import BackendAuthSocialProviderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendAuthSocialProviderConfig
      .builder()
      .optionallyWith(
        clientId.map(value => __string.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        clientSecret.map(value => __string.unwrap(value): java.lang.String)
      )(_.clientSecret)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly =
    zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig
      .wrap(buildAwsValue())
}
object BackendAuthSocialProviderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendAuthSocialProviderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig =
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig(
        clientId.map(value => value),
        clientSecret.map(value => value)
      )
    def clientId: Option[__string]
    def clientSecret: Option[__string]
    def getClientId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getClientSecret: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientSecret", clientSecret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAuthSocialProviderConfig
  ) extends zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly {
    override val clientId: Option[__string] = scala
      .Option(impl.clientId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val clientSecret: Option[__string] = scala
      .Option(impl.clientSecret())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAuthSocialProviderConfig
  ): zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly =
    new Wrapper(impl)
}
