package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTokenResponse(
    appId: Option[__string] = None,
    challengeCode: Option[__string] = None,
    sessionId: Option[__string] = None,
    ttl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateTokenResponse = {
    import CreateTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateTokenResponse
      .builder()
      .optionallyWith(
        appId.map(value => __string.unwrap(value): java.lang.String)
      )(_.appId)
      .optionallyWith(
        challengeCode.map(value => __string.unwrap(value): java.lang.String)
      )(_.challengeCode)
      .optionallyWith(
        sessionId.map(value => __string.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        ttl.map(value => __string.unwrap(value): java.lang.String)
      )(_.ttl)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.CreateTokenResponse.ReadOnly =
    zio.aws.amplifybackend.model.CreateTokenResponse.wrap(buildAwsValue())
}
object CreateTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.CreateTokenResponse =
      zio.aws.amplifybackend.model.CreateTokenResponse(
        appId.map(value => value),
        challengeCode.map(value => value),
        sessionId.map(value => value),
        ttl.map(value => value)
      )
    def appId: Option[__string]
    def challengeCode: Option[__string]
    def sessionId: Option[__string]
    def ttl: Option[__string]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getChallengeCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("challengeCode", challengeCode)
    def getSessionId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getTtl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("ttl", ttl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateTokenResponse
  ) extends zio.aws.amplifybackend.model.CreateTokenResponse.ReadOnly {
    override val appId: Option[__string] = scala
      .Option(impl.appId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val challengeCode: Option[__string] = scala
      .Option(impl.challengeCode())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val sessionId: Option[__string] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val ttl: Option[__string] = scala
      .Option(impl.ttl())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateTokenResponse
  ): zio.aws.amplifybackend.model.CreateTokenResponse.ReadOnly = new Wrapper(
    impl
  )
}
