package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BackendStoragePermissions(
    authenticated: Iterable[zio.aws.amplifybackend.model.AuthenticatedElement],
    unAuthenticated: Option[
      Iterable[zio.aws.amplifybackend.model.UnAuthenticatedElement]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendStoragePermissions = {
    import BackendStoragePermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendStoragePermissions
      .builder()
      .authenticatedWithStrings(authenticated.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        unAuthenticated.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.unAuthenticatedWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly =
    zio.aws.amplifybackend.model.BackendStoragePermissions.wrap(buildAwsValue())
}
object BackendStoragePermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendStoragePermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.BackendStoragePermissions =
      zio.aws.amplifybackend.model.BackendStoragePermissions(
        authenticated,
        unAuthenticated.map(value => value)
      )
    def authenticated: List[zio.aws.amplifybackend.model.AuthenticatedElement]
    def unAuthenticated
        : Option[List[zio.aws.amplifybackend.model.UnAuthenticatedElement]]
    def getAuthenticated: ZIO[Any, Nothing, List[
      zio.aws.amplifybackend.model.AuthenticatedElement
    ]] = ZIO.succeed(authenticated)
    def getUnAuthenticated: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.UnAuthenticatedElement
    ]] = AwsError.unwrapOptionField("unAuthenticated", unAuthenticated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendStoragePermissions
  ) extends zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly {
    override val authenticated
        : List[zio.aws.amplifybackend.model.AuthenticatedElement] = impl
      .authenticated()
      .asScala
      .map { item =>
        zio.aws.amplifybackend.model.AuthenticatedElement.wrap(item)
      }
      .toList
    override val unAuthenticated
        : Option[List[zio.aws.amplifybackend.model.UnAuthenticatedElement]] =
      scala
        .Option(impl.unAuthenticated())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifybackend.model.UnAuthenticatedElement.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendStoragePermissions
  ): zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly =
    new Wrapper(impl)
}
