package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateBackendAuthForgotPasswordConfig(
    deliveryMethod: Optional[zio.aws.amplifybackend.model.DeliveryMethod] =
      Optional.Absent,
    emailSettings: Optional[zio.aws.amplifybackend.model.EmailSettings] =
      Optional.Absent,
    smsSettings: Optional[zio.aws.amplifybackend.model.SmsSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig = {
    import UpdateBackendAuthForgotPasswordConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
      .builder()
      .optionallyWith(deliveryMethod.map(value => value.unwrap))(
        _.deliveryMethod
      )
      .optionallyWith(emailSettings.map(value => value.buildAwsValue()))(
        _.emailSettings
      )
      .optionallyWith(smsSettings.map(value => value.buildAwsValue()))(
        _.smsSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
      .wrap(buildAwsValue())
}
object UpdateBackendAuthForgotPasswordConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig =
      zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig(
        deliveryMethod.map(value => value),
        emailSettings.map(value => value.asEditable),
        smsSettings.map(value => value.asEditable)
      )
    def deliveryMethod: Optional[zio.aws.amplifybackend.model.DeliveryMethod]
    def emailSettings
        : Optional[zio.aws.amplifybackend.model.EmailSettings.ReadOnly]
    def smsSettings: Optional[zio.aws.amplifybackend.model.SmsSettings.ReadOnly]
    def getDeliveryMethod
        : ZIO[Any, AwsError, zio.aws.amplifybackend.model.DeliveryMethod] =
      AwsError.unwrapOptionField("deliveryMethod", deliveryMethod)
    def getEmailSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.EmailSettings.ReadOnly
    ] = AwsError.unwrapOptionField("emailSettings", emailSettings)
    def getSmsSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.SmsSettings.ReadOnly
    ] = AwsError.unwrapOptionField("smsSettings", smsSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig.ReadOnly {
    override val deliveryMethod
        : Optional[zio.aws.amplifybackend.model.DeliveryMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryMethod())
        .map(value => zio.aws.amplifybackend.model.DeliveryMethod.wrap(value))
    override val emailSettings
        : Optional[zio.aws.amplifybackend.model.EmailSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailSettings())
        .map(value => zio.aws.amplifybackend.model.EmailSettings.wrap(value))
    override val smsSettings
        : Optional[zio.aws.amplifybackend.model.SmsSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smsSettings())
        .map(value => zio.aws.amplifybackend.model.SmsSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
  ): zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig.ReadOnly =
    new Wrapper(impl)
}
