package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBackendAuthForgotPasswordConfig(
    deliveryMethod: zio.aws.amplifybackend.model.DeliveryMethod,
    emailSettings: Optional[zio.aws.amplifybackend.model.EmailSettings] =
      Optional.Absent,
    smsSettings: Optional[zio.aws.amplifybackend.model.SmsSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthForgotPasswordConfig = {
    import CreateBackendAuthForgotPasswordConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthForgotPasswordConfig
      .builder()
      .deliveryMethod(deliveryMethod.unwrap)
      .optionallyWith(emailSettings.map(value => value.buildAwsValue()))(
        _.emailSettings
      )
      .optionallyWith(smsSettings.map(value => value.buildAwsValue()))(
        _.smsSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendAuthForgotPasswordConfig.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendAuthForgotPasswordConfig
      .wrap(buildAwsValue())
}
object CreateBackendAuthForgotPasswordConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthForgotPasswordConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.CreateBackendAuthForgotPasswordConfig =
      zio.aws.amplifybackend.model.CreateBackendAuthForgotPasswordConfig(
        deliveryMethod,
        emailSettings.map(value => value.asEditable),
        smsSettings.map(value => value.asEditable)
      )
    def deliveryMethod: zio.aws.amplifybackend.model.DeliveryMethod
    def emailSettings
        : Optional[zio.aws.amplifybackend.model.EmailSettings.ReadOnly]
    def smsSettings: Optional[zio.aws.amplifybackend.model.SmsSettings.ReadOnly]
    def getDeliveryMethod
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.DeliveryMethod] =
      ZIO.succeed(deliveryMethod)
    def getEmailSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.EmailSettings.ReadOnly
    ] = AwsError.unwrapOptionField("emailSettings", emailSettings)
    def getSmsSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.SmsSettings.ReadOnly
    ] = AwsError.unwrapOptionField("smsSettings", smsSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthForgotPasswordConfig
  ) extends zio.aws.amplifybackend.model.CreateBackendAuthForgotPasswordConfig.ReadOnly {
    override val deliveryMethod: zio.aws.amplifybackend.model.DeliveryMethod =
      zio.aws.amplifybackend.model.DeliveryMethod.wrap(impl.deliveryMethod())
    override val emailSettings
        : Optional[zio.aws.amplifybackend.model.EmailSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailSettings())
        .map(value => zio.aws.amplifybackend.model.EmailSettings.wrap(value))
    override val smsSettings
        : Optional[zio.aws.amplifybackend.model.SmsSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smsSettings())
        .map(value => zio.aws.amplifybackend.model.SmsSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthForgotPasswordConfig
  ): zio.aws.amplifybackend.model.CreateBackendAuthForgotPasswordConfig.ReadOnly =
    new Wrapper(impl)
}
