package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateBackendStorageRequest(
    appId: __string,
    backendEnvironmentName: __string,
    resourceConfig: zio.aws.amplifybackend.model.CreateBackendStorageResourceConfig,
    resourceName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageRequest = {
    import CreateBackendStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageRequest
      .builder()
      .appId(appId: java.lang.String)
      .backendEnvironmentName(backendEnvironmentName: java.lang.String)
      .resourceConfig(resourceConfig.buildAwsValue())
      .resourceName(resourceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendStorageRequest.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendStorageRequest
      .wrap(buildAwsValue())
}
object CreateBackendStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.CreateBackendStorageRequest =
      zio.aws.amplifybackend.model.CreateBackendStorageRequest(
        appId,
        backendEnvironmentName,
        resourceConfig.asEditable,
        resourceName
      )
    def appId: __string
    def backendEnvironmentName: __string
    def resourceConfig
        : zio.aws.amplifybackend.model.CreateBackendStorageResourceConfig.ReadOnly
    def resourceName: __string
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getResourceConfig: ZIO[
      Any,
      Nothing,
      zio.aws.amplifybackend.model.CreateBackendStorageResourceConfig.ReadOnly
    ] = ZIO.succeed(resourceConfig)
    def getResourceName: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageRequest
  ) extends zio.aws.amplifybackend.model.CreateBackendStorageRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val backendEnvironmentName: __string =
      impl.backendEnvironmentName(): __string
    override val resourceConfig
        : zio.aws.amplifybackend.model.CreateBackendStorageResourceConfig.ReadOnly =
      zio.aws.amplifybackend.model.CreateBackendStorageResourceConfig
        .wrap(impl.resourceConfig())
    override val resourceName: __string = impl.resourceName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageRequest
  ): zio.aws.amplifybackend.model.CreateBackendStorageRequest.ReadOnly =
    new Wrapper(impl)
}
