package zio.aws.amplifybackend
import zio.aws.amplifybackend.model.DeleteTokenResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.amplifybackend.model.{
  ListS3BucketsRequest,
  GetBackendApiRequest,
  ImportBackendAuthRequest,
  UpdateBackendJobRequest,
  UpdateBackendAuthRequest,
  GetBackendJobRequest,
  GetBackendAuthRequest,
  GetBackendStorageRequest,
  UpdateBackendStorageRequest,
  DeleteTokenRequest,
  UpdateBackendApiRequest,
  DeleteBackendRequest,
  DeleteBackendStorageRequest,
  CreateBackendAuthRequest,
  DeleteBackendAuthRequest,
  CreateBackendStorageRequest,
  CreateTokenRequest,
  RemoveAllBackendsRequest,
  GetBackendApiModelsRequest,
  GetTokenRequest,
  ListBackendJobsRequest,
  RemoveBackendConfigRequest,
  DeleteBackendApiRequest,
  UpdateBackendConfigRequest,
  CloneBackendRequest,
  ImportBackendStorageRequest,
  CreateBackendConfigRequest,
  GenerateBackendApiModelsRequest,
  CreateBackendApiRequest,
  GetBackendRequest,
  CreateBackendRequest
}
import software.amazon.awssdk.services.amplifybackend.AmplifyBackendAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object AmplifyBackendMock extends Mock[AmplifyBackend] {
  object GetToken
      extends Effect[
        GetTokenRequest,
        AwsError,
        zio.aws.amplifybackend.model.GetTokenResponse.ReadOnly
      ]
  object GetBackendAuth
      extends Effect[
        GetBackendAuthRequest,
        AwsError,
        zio.aws.amplifybackend.model.GetBackendAuthResponse.ReadOnly
      ]
  object CreateToken
      extends Effect[
        CreateTokenRequest,
        AwsError,
        zio.aws.amplifybackend.model.CreateTokenResponse.ReadOnly
      ]
  object GetBackendAPIModels
      extends Effect[
        GetBackendApiModelsRequest,
        AwsError,
        zio.aws.amplifybackend.model.GetBackendApiModelsResponse.ReadOnly
      ]
  object UpdateBackendAuth
      extends Effect[
        UpdateBackendAuthRequest,
        AwsError,
        zio.aws.amplifybackend.model.UpdateBackendAuthResponse.ReadOnly
      ]
  object CreateBackendStorage
      extends Effect[
        CreateBackendStorageRequest,
        AwsError,
        zio.aws.amplifybackend.model.CreateBackendStorageResponse.ReadOnly
      ]
  object DeleteToken extends Effect[DeleteTokenRequest, AwsError, ReadOnly]
  object UpdateBackendJob
      extends Effect[
        UpdateBackendJobRequest,
        AwsError,
        zio.aws.amplifybackend.model.UpdateBackendJobResponse.ReadOnly
      ]
  object DeleteBackendAPI
      extends Effect[
        DeleteBackendApiRequest,
        AwsError,
        zio.aws.amplifybackend.model.DeleteBackendApiResponse.ReadOnly
      ]
  object UpdateBackendConfig
      extends Effect[
        UpdateBackendConfigRequest,
        AwsError,
        zio.aws.amplifybackend.model.UpdateBackendConfigResponse.ReadOnly
      ]
  object GetBackend
      extends Effect[
        GetBackendRequest,
        AwsError,
        zio.aws.amplifybackend.model.GetBackendResponse.ReadOnly
      ]
  object UpdateBackendStorage
      extends Effect[
        UpdateBackendStorageRequest,
        AwsError,
        zio.aws.amplifybackend.model.UpdateBackendStorageResponse.ReadOnly
      ]
  object ImportBackendStorage
      extends Effect[
        ImportBackendStorageRequest,
        AwsError,
        zio.aws.amplifybackend.model.ImportBackendStorageResponse.ReadOnly
      ]
  object GetBackendJob
      extends Effect[
        GetBackendJobRequest,
        AwsError,
        zio.aws.amplifybackend.model.GetBackendJobResponse.ReadOnly
      ]
  object ListS3Buckets
      extends Stream[
        ListS3BucketsRequest,
        AwsError,
        zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly
      ]
  object ListS3BucketsPaginated
      extends Effect[
        ListS3BucketsRequest,
        AwsError,
        zio.aws.amplifybackend.model.ListS3BucketsResponse.ReadOnly
      ]
  object GenerateBackendAPIModels
      extends Effect[
        GenerateBackendApiModelsRequest,
        AwsError,
        zio.aws.amplifybackend.model.GenerateBackendApiModelsResponse.ReadOnly
      ]
  object ListBackendJobs
      extends Stream[
        ListBackendJobsRequest,
        AwsError,
        zio.aws.amplifybackend.model.BackendJobRespObj.ReadOnly
      ]
  object ListBackendJobsPaginated
      extends Effect[
        ListBackendJobsRequest,
        AwsError,
        zio.aws.amplifybackend.model.ListBackendJobsResponse.ReadOnly
      ]
  object CreateBackend
      extends Effect[
        CreateBackendRequest,
        AwsError,
        zio.aws.amplifybackend.model.CreateBackendResponse.ReadOnly
      ]
  object RemoveBackendConfig
      extends Effect[
        RemoveBackendConfigRequest,
        AwsError,
        zio.aws.amplifybackend.model.RemoveBackendConfigResponse.ReadOnly
      ]
  object UpdateBackendAPI
      extends Effect[
        UpdateBackendApiRequest,
        AwsError,
        zio.aws.amplifybackend.model.UpdateBackendApiResponse.ReadOnly
      ]
  object DeleteBackendStorage
      extends Effect[
        DeleteBackendStorageRequest,
        AwsError,
        zio.aws.amplifybackend.model.DeleteBackendStorageResponse.ReadOnly
      ]
  object DeleteBackend
      extends Effect[
        DeleteBackendRequest,
        AwsError,
        zio.aws.amplifybackend.model.DeleteBackendResponse.ReadOnly
      ]
  object GetBackendStorage
      extends Effect[
        GetBackendStorageRequest,
        AwsError,
        zio.aws.amplifybackend.model.GetBackendStorageResponse.ReadOnly
      ]
  object RemoveAllBackends
      extends Effect[
        RemoveAllBackendsRequest,
        AwsError,
        zio.aws.amplifybackend.model.RemoveAllBackendsResponse.ReadOnly
      ]
  object DeleteBackendAuth
      extends Effect[
        DeleteBackendAuthRequest,
        AwsError,
        zio.aws.amplifybackend.model.DeleteBackendAuthResponse.ReadOnly
      ]
  object ImportBackendAuth
      extends Effect[
        ImportBackendAuthRequest,
        AwsError,
        zio.aws.amplifybackend.model.ImportBackendAuthResponse.ReadOnly
      ]
  object CloneBackend
      extends Effect[
        CloneBackendRequest,
        AwsError,
        zio.aws.amplifybackend.model.CloneBackendResponse.ReadOnly
      ]
  object CreateBackendAuth
      extends Effect[
        CreateBackendAuthRequest,
        AwsError,
        zio.aws.amplifybackend.model.CreateBackendAuthResponse.ReadOnly
      ]
  object CreateBackendConfig
      extends Effect[
        CreateBackendConfigRequest,
        AwsError,
        zio.aws.amplifybackend.model.CreateBackendConfigResponse.ReadOnly
      ]
  object GetBackendAPI
      extends Effect[
        GetBackendApiRequest,
        AwsError,
        zio.aws.amplifybackend.model.GetBackendApiResponse.ReadOnly
      ]
  object CreateBackendAPI
      extends Effect[
        CreateBackendApiRequest,
        AwsError,
        zio.aws.amplifybackend.model.CreateBackendApiResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AmplifyBackend] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, AmplifyBackend] { rts =>
        zio.ZIO.succeed {
          new AmplifyBackend {
            val api: AmplifyBackendAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): AmplifyBackend = this
            def getToken(request: GetTokenRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.GetTokenResponse.ReadOnly
            ] = proxy(GetToken, request)
            def getBackendAuth(request: GetBackendAuthRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.GetBackendAuthResponse.ReadOnly
            ] = proxy(GetBackendAuth, request)
            def createToken(request: CreateTokenRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.CreateTokenResponse.ReadOnly
            ] = proxy(CreateToken, request)
            def getBackendAPIModels(request: GetBackendApiModelsRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.GetBackendApiModelsResponse.ReadOnly
            ] = proxy(GetBackendAPIModels, request)
            def updateBackendAuth(request: UpdateBackendAuthRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.UpdateBackendAuthResponse.ReadOnly
            ] = proxy(UpdateBackendAuth, request)
            def createBackendStorage(request: CreateBackendStorageRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.CreateBackendStorageResponse.ReadOnly
            ] = proxy(CreateBackendStorage, request)
            def deleteToken(
                request: DeleteTokenRequest
            ): IO[AwsError, ReadOnly] = proxy(DeleteToken, request)
            def updateBackendJob(request: UpdateBackendJobRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.UpdateBackendJobResponse.ReadOnly
            ] = proxy(UpdateBackendJob, request)
            def deleteBackendAPI(request: DeleteBackendApiRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.DeleteBackendApiResponse.ReadOnly
            ] = proxy(DeleteBackendAPI, request)
            def updateBackendConfig(request: UpdateBackendConfigRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.UpdateBackendConfigResponse.ReadOnly
            ] = proxy(UpdateBackendConfig, request)
            def getBackend(request: GetBackendRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.GetBackendResponse.ReadOnly
            ] = proxy(GetBackend, request)
            def updateBackendStorage(request: UpdateBackendStorageRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.UpdateBackendStorageResponse.ReadOnly
            ] = proxy(UpdateBackendStorage, request)
            def importBackendStorage(request: ImportBackendStorageRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.ImportBackendStorageResponse.ReadOnly
            ] = proxy(ImportBackendStorage, request)
            def getBackendJob(request: GetBackendJobRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.GetBackendJobResponse.ReadOnly
            ] = proxy(GetBackendJob, request)
            def listS3Buckets(request: ListS3BucketsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly
            ] = rts.unsafeRun(proxy(ListS3Buckets, request))
            def listS3BucketsPaginated(request: ListS3BucketsRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.ListS3BucketsResponse.ReadOnly
            ] = proxy(ListS3BucketsPaginated, request)
            def generateBackendAPIModels(
                request: GenerateBackendApiModelsRequest
            ): IO[
              AwsError,
              zio.aws.amplifybackend.model.GenerateBackendApiModelsResponse.ReadOnly
            ] = proxy(GenerateBackendAPIModels, request)
            def listBackendJobs(request: ListBackendJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.amplifybackend.model.BackendJobRespObj.ReadOnly
            ] = rts.unsafeRun(proxy(ListBackendJobs, request))
            def listBackendJobsPaginated(request: ListBackendJobsRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.ListBackendJobsResponse.ReadOnly
            ] = proxy(ListBackendJobsPaginated, request)
            def createBackend(request: CreateBackendRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.CreateBackendResponse.ReadOnly
            ] = proxy(CreateBackend, request)
            def removeBackendConfig(request: RemoveBackendConfigRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.RemoveBackendConfigResponse.ReadOnly
            ] = proxy(RemoveBackendConfig, request)
            def updateBackendAPI(request: UpdateBackendApiRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.UpdateBackendApiResponse.ReadOnly
            ] = proxy(UpdateBackendAPI, request)
            def deleteBackendStorage(request: DeleteBackendStorageRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.DeleteBackendStorageResponse.ReadOnly
            ] = proxy(DeleteBackendStorage, request)
            def deleteBackend(request: DeleteBackendRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.DeleteBackendResponse.ReadOnly
            ] = proxy(DeleteBackend, request)
            def getBackendStorage(request: GetBackendStorageRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.GetBackendStorageResponse.ReadOnly
            ] = proxy(GetBackendStorage, request)
            def removeAllBackends(request: RemoveAllBackendsRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.RemoveAllBackendsResponse.ReadOnly
            ] = proxy(RemoveAllBackends, request)
            def deleteBackendAuth(request: DeleteBackendAuthRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.DeleteBackendAuthResponse.ReadOnly
            ] = proxy(DeleteBackendAuth, request)
            def importBackendAuth(request: ImportBackendAuthRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.ImportBackendAuthResponse.ReadOnly
            ] = proxy(ImportBackendAuth, request)
            def cloneBackend(request: CloneBackendRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.CloneBackendResponse.ReadOnly
            ] = proxy(CloneBackend, request)
            def createBackendAuth(request: CreateBackendAuthRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.CreateBackendAuthResponse.ReadOnly
            ] = proxy(CreateBackendAuth, request)
            def createBackendConfig(request: CreateBackendConfigRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.CreateBackendConfigResponse.ReadOnly
            ] = proxy(CreateBackendConfig, request)
            def getBackendAPI(request: GetBackendApiRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.GetBackendApiResponse.ReadOnly
            ] = proxy(GetBackendAPI, request)
            def createBackendAPI(request: CreateBackendApiRequest): IO[
              AwsError,
              zio.aws.amplifybackend.model.CreateBackendApiResponse.ReadOnly
            ] = proxy(CreateBackendAPI, request)
          }
        }
      }
    }
  }
}
