package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateBackendAuthVerificationMessageConfig(
    deliveryMethod: zio.aws.amplifybackend.model.DeliveryMethod,
    emailSettings: Option[zio.aws.amplifybackend.model.EmailSettings] = None,
    smsSettings: Option[zio.aws.amplifybackend.model.SmsSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig = {
    import UpdateBackendAuthVerificationMessageConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig
      .builder()
      .deliveryMethod(deliveryMethod.unwrap)
      .optionallyWith(emailSettings.map(value => value.buildAwsValue()))(
        _.emailSettings
      )
      .optionallyWith(smsSettings.map(value => value.buildAwsValue()))(
        _.smsSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig
      .wrap(buildAwsValue())
}
object UpdateBackendAuthVerificationMessageConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig =
      zio.aws.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig(
        deliveryMethod,
        emailSettings.map(value => value.asEditable),
        smsSettings.map(value => value.asEditable)
      )
    def deliveryMethod: zio.aws.amplifybackend.model.DeliveryMethod
    def emailSettings
        : Option[zio.aws.amplifybackend.model.EmailSettings.ReadOnly]
    def smsSettings: Option[zio.aws.amplifybackend.model.SmsSettings.ReadOnly]
    def getDeliveryMethod
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.DeliveryMethod] =
      ZIO.succeed(deliveryMethod)
    def getEmailSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.EmailSettings.ReadOnly
    ] = AwsError.unwrapOptionField("emailSettings", emailSettings)
    def getSmsSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.SmsSettings.ReadOnly
    ] = AwsError.unwrapOptionField("smsSettings", smsSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig.ReadOnly {
    override val deliveryMethod: zio.aws.amplifybackend.model.DeliveryMethod =
      zio.aws.amplifybackend.model.DeliveryMethod.wrap(impl.deliveryMethod())
    override val emailSettings
        : Option[zio.aws.amplifybackend.model.EmailSettings.ReadOnly] = scala
      .Option(impl.emailSettings())
      .map(value => zio.aws.amplifybackend.model.EmailSettings.wrap(value))
    override val smsSettings
        : Option[zio.aws.amplifybackend.model.SmsSettings.ReadOnly] = scala
      .Option(impl.smsSettings())
      .map(value => zio.aws.amplifybackend.model.SmsSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig
  ): zio.aws.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig.ReadOnly =
    new Wrapper(impl)
}
