package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBackendResponse(
    amplifyFeatureFlags: Option[__string] = None,
    amplifyMetaConfig: Option[__string] = None,
    appId: Option[__string] = None,
    appName: Option[__string] = None,
    backendEnvironmentList: Option[Iterable[__string]] = None,
    backendEnvironmentName: Option[__string] = None,
    error: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetBackendResponse = {
    import GetBackendResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetBackendResponse
      .builder()
      .optionallyWith(
        amplifyFeatureFlags.map(value => value: java.lang.String)
      )(_.amplifyFeatureFlags)
      .optionallyWith(amplifyMetaConfig.map(value => value: java.lang.String))(
        _.amplifyMetaConfig
      )
      .optionallyWith(appId.map(value => value: java.lang.String))(_.appId)
      .optionallyWith(appName.map(value => value: java.lang.String))(_.appName)
      .optionallyWith(
        backendEnvironmentList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.backendEnvironmentList)
      .optionallyWith(
        backendEnvironmentName.map(value => value: java.lang.String)
      )(_.backendEnvironmentName)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.GetBackendResponse.ReadOnly =
    zio.aws.amplifybackend.model.GetBackendResponse.wrap(buildAwsValue())
}
object GetBackendResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetBackendResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetBackendResponse =
      zio.aws.amplifybackend.model.GetBackendResponse(
        amplifyFeatureFlags.map(value => value),
        amplifyMetaConfig.map(value => value),
        appId.map(value => value),
        appName.map(value => value),
        backendEnvironmentList.map(value => value),
        backendEnvironmentName.map(value => value),
        error.map(value => value)
      )
    def amplifyFeatureFlags: Option[__string]
    def amplifyMetaConfig: Option[__string]
    def appId: Option[__string]
    def appName: Option[__string]
    def backendEnvironmentList: Option[List[__string]]
    def backendEnvironmentName: Option[__string]
    def error: Option[__string]
    def getAmplifyFeatureFlags: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("amplifyFeatureFlags", amplifyFeatureFlags)
    def getAmplifyMetaConfig: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("amplifyMetaConfig", amplifyMetaConfig)
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getAppName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appName", appName)
    def getBackendEnvironmentList: ZIO[Any, AwsError, List[__string]] = AwsError
      .unwrapOptionField("backendEnvironmentList", backendEnvironmentList)
    def getBackendEnvironmentName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("backendEnvironmentName", backendEnvironmentName)
    def getError: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendResponse
  ) extends zio.aws.amplifybackend.model.GetBackendResponse.ReadOnly {
    override val amplifyFeatureFlags: Option[__string] =
      scala.Option(impl.amplifyFeatureFlags()).map(value => value: __string)
    override val amplifyMetaConfig: Option[__string] =
      scala.Option(impl.amplifyMetaConfig()).map(value => value: __string)
    override val appId: Option[__string] =
      scala.Option(impl.appId()).map(value => value: __string)
    override val appName: Option[__string] =
      scala.Option(impl.appName()).map(value => value: __string)
    override val backendEnvironmentList: Option[List[__string]] = scala
      .Option(impl.backendEnvironmentList())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val backendEnvironmentName: Option[__string] =
      scala.Option(impl.backendEnvironmentName()).map(value => value: __string)
    override val error: Option[__string] =
      scala.Option(impl.error()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendResponse
  ): zio.aws.amplifybackend.model.GetBackendResponse.ReadOnly = new Wrapper(
    impl
  )
}
