package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__double
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateBackendAuthPasswordPolicyConfig(
    additionalConstraints: Option[
      Iterable[zio.aws.amplifybackend.model.AdditionalConstraintsElement]
    ] = None,
    minimumLength: Option[__double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig = {
    import UpdateBackendAuthPasswordPolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig
      .builder()
      .optionallyWith(
        additionalConstraints.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.additionalConstraintsWithStrings)
      .optionallyWith(
        minimumLength.map(value => __double.unwrap(value): java.lang.Double)
      )(_.minimumLength)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig
      .wrap(buildAwsValue())
}
object UpdateBackendAuthPasswordPolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig =
      zio.aws.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig(
        additionalConstraints.map(value => value),
        minimumLength.map(value => value)
      )
    def additionalConstraints: Option[
      List[zio.aws.amplifybackend.model.AdditionalConstraintsElement]
    ]
    def minimumLength: Option[__double]
    def getAdditionalConstraints: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.AdditionalConstraintsElement
    ]] =
      AwsError.unwrapOptionField("additionalConstraints", additionalConstraints)
    def getMinimumLength: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("minimumLength", minimumLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig.ReadOnly {
    override val additionalConstraints: Option[
      List[zio.aws.amplifybackend.model.AdditionalConstraintsElement]
    ] = scala
      .Option(impl.additionalConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifybackend.model.AdditionalConstraintsElement.wrap(item)
        }.toList
      )
    override val minimumLength: Option[__double] = scala
      .Option(impl.minimumLength())
      .map(value => zio.aws.amplifybackend.model.primitives.__double(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig
  ): zio.aws.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig.ReadOnly =
    new Wrapper(impl)
}
