package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteBackendStorageRequest(
    appId: __string,
    backendEnvironmentName: __string,
    resourceName: __string,
    serviceName: zio.aws.amplifybackend.model.ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageRequest = {
    import DeleteBackendStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageRequest
      .builder()
      .appId(__string.unwrap(appId): java.lang.String)
      .backendEnvironmentName(
        __string.unwrap(backendEnvironmentName): java.lang.String
      )
      .resourceName(__string.unwrap(resourceName): java.lang.String)
      .serviceName(serviceName.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.DeleteBackendStorageRequest.ReadOnly =
    zio.aws.amplifybackend.model.DeleteBackendStorageRequest
      .wrap(buildAwsValue())
}
object DeleteBackendStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.DeleteBackendStorageRequest =
      zio.aws.amplifybackend.model.DeleteBackendStorageRequest(
        appId,
        backendEnvironmentName,
        resourceName,
        serviceName
      )
    def appId: __string
    def backendEnvironmentName: __string
    def resourceName: __string
    def serviceName: zio.aws.amplifybackend.model.ServiceName
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getResourceName: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceName)
    def getServiceName
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.ServiceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageRequest
  ) extends zio.aws.amplifybackend.model.DeleteBackendStorageRequest.ReadOnly {
    override val appId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.appId())
    override val backendEnvironmentName: __string =
      zio.aws.amplifybackend.model.primitives
        .__string(impl.backendEnvironmentName())
    override val resourceName: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.resourceName())
    override val serviceName: zio.aws.amplifybackend.model.ServiceName =
      zio.aws.amplifybackend.model.ServiceName.wrap(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageRequest
  ): zio.aws.amplifybackend.model.DeleteBackendStorageRequest.ReadOnly =
    new Wrapper(impl)
}
