package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BackendAPIConflictResolution(
    resolutionStrategy: Option[
      zio.aws.amplifybackend.model.ResolutionStrategy
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendAPIConflictResolution = {
    import BackendAPIConflictResolution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIConflictResolution
      .builder()
      .optionallyWith(resolutionStrategy.map(value => value.unwrap))(
        _.resolutionStrategy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.BackendAPIConflictResolution.ReadOnly =
    zio.aws.amplifybackend.model.BackendAPIConflictResolution
      .wrap(buildAwsValue())
}
object BackendAPIConflictResolution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIConflictResolution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.BackendAPIConflictResolution =
      zio.aws.amplifybackend.model
        .BackendAPIConflictResolution(resolutionStrategy.map(value => value))
    def resolutionStrategy
        : Option[zio.aws.amplifybackend.model.ResolutionStrategy]
    def getResolutionStrategy
        : ZIO[Any, AwsError, zio.aws.amplifybackend.model.ResolutionStrategy] =
      AwsError.unwrapOptionField("resolutionStrategy", resolutionStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIConflictResolution
  ) extends zio.aws.amplifybackend.model.BackendAPIConflictResolution.ReadOnly {
    override val resolutionStrategy
        : Option[zio.aws.amplifybackend.model.ResolutionStrategy] = scala
      .Option(impl.resolutionStrategy())
      .map(value => zio.aws.amplifybackend.model.ResolutionStrategy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIConflictResolution
  ): zio.aws.amplifybackend.model.BackendAPIConflictResolution.ReadOnly =
    new Wrapper(impl)
}
