package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateBackendJobRequest(
    appId: __string,
    backendEnvironmentName: __string,
    jobId: __string,
    operation: Option[__string] = None,
    status: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest = {
    import UpdateBackendJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest
      .builder()
      .appId(__string.unwrap(appId): java.lang.String)
      .backendEnvironmentName(
        __string.unwrap(backendEnvironmentName): java.lang.String
      )
      .jobId(__string.unwrap(jobId): java.lang.String)
      .optionallyWith(
        operation.map(value => __string.unwrap(value): java.lang.String)
      )(_.operation)
      .optionallyWith(
        status.map(value => __string.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendJobRequest.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendJobRequest.wrap(buildAwsValue())
}
object UpdateBackendJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.UpdateBackendJobRequest =
      zio.aws.amplifybackend.model.UpdateBackendJobRequest(
        appId,
        backendEnvironmentName,
        jobId,
        operation.map(value => value),
        status.map(value => value)
      )
    def appId: __string
    def backendEnvironmentName: __string
    def jobId: __string
    def operation: Option[__string]
    def status: Option[__string]
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getJobId: ZIO[Any, Nothing, __string] = ZIO.succeed(jobId)
    def getOperation: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operation", operation)
    def getStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest
  ) extends zio.aws.amplifybackend.model.UpdateBackendJobRequest.ReadOnly {
    override val appId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.appId())
    override val backendEnvironmentName: __string =
      zio.aws.amplifybackend.model.primitives
        .__string(impl.backendEnvironmentName())
    override val jobId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.jobId())
    override val operation: Option[__string] = scala
      .Option(impl.operation())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val status: Option[__string] = scala
      .Option(impl.status())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest
  ): zio.aws.amplifybackend.model.UpdateBackendJobRequest.ReadOnly =
    new Wrapper(impl)
}
