package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Settings(
    mfaTypes: Option[Iterable[zio.aws.amplifybackend.model.MfaTypesElement]] =
      None,
    smsMessage: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.Settings = {
    import Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.Settings
      .builder()
      .optionallyWith(
        mfaTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.mfaTypesWithStrings)
      .optionallyWith(
        smsMessage.map(value => __string.unwrap(value): java.lang.String)
      )(_.smsMessage)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.Settings.ReadOnly =
    zio.aws.amplifybackend.model.Settings.wrap(buildAwsValue())
}
object Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.Settings =
      zio.aws.amplifybackend.model
        .Settings(mfaTypes.map(value => value), smsMessage.map(value => value))
    def mfaTypes: Option[List[zio.aws.amplifybackend.model.MfaTypesElement]]
    def smsMessage: Option[__string]
    def getMfaTypes: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.MfaTypesElement
    ]] = AwsError.unwrapOptionField("mfaTypes", mfaTypes)
    def getSmsMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("smsMessage", smsMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.Settings
  ) extends zio.aws.amplifybackend.model.Settings.ReadOnly {
    override val mfaTypes
        : Option[List[zio.aws.amplifybackend.model.MfaTypesElement]] = scala
      .Option(impl.mfaTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifybackend.model.MfaTypesElement.wrap(item)
        }.toList
      )
    override val smsMessage: Option[__string] = scala
      .Option(impl.smsMessage())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.Settings
  ): zio.aws.amplifybackend.model.Settings.ReadOnly = new Wrapper(impl)
}
