package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportBackendAuthRequest(
    appId: __string,
    backendEnvironmentName: __string,
    identityPoolId: Option[__string] = None,
    nativeClientId: __string,
    userPoolId: __string,
    webClientId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest = {
    import ImportBackendAuthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest
      .builder()
      .appId(__string.unwrap(appId): java.lang.String)
      .backendEnvironmentName(
        __string.unwrap(backendEnvironmentName): java.lang.String
      )
      .optionallyWith(
        identityPoolId.map(value => __string.unwrap(value): java.lang.String)
      )(_.identityPoolId)
      .nativeClientId(__string.unwrap(nativeClientId): java.lang.String)
      .userPoolId(__string.unwrap(userPoolId): java.lang.String)
      .webClientId(__string.unwrap(webClientId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.ImportBackendAuthRequest.ReadOnly =
    zio.aws.amplifybackend.model.ImportBackendAuthRequest.wrap(buildAwsValue())
}
object ImportBackendAuthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.ImportBackendAuthRequest =
      zio.aws.amplifybackend.model.ImportBackendAuthRequest(
        appId,
        backendEnvironmentName,
        identityPoolId.map(value => value),
        nativeClientId,
        userPoolId,
        webClientId
      )
    def appId: __string
    def backendEnvironmentName: __string
    def identityPoolId: Option[__string]
    def nativeClientId: __string
    def userPoolId: __string
    def webClientId: __string
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getIdentityPoolId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getNativeClientId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(nativeClientId)
    def getUserPoolId: ZIO[Any, Nothing, __string] = ZIO.succeed(userPoolId)
    def getWebClientId: ZIO[Any, Nothing, __string] = ZIO.succeed(webClientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest
  ) extends zio.aws.amplifybackend.model.ImportBackendAuthRequest.ReadOnly {
    override val appId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.appId())
    override val backendEnvironmentName: __string =
      zio.aws.amplifybackend.model.primitives
        .__string(impl.backendEnvironmentName())
    override val identityPoolId: Option[__string] = scala
      .Option(impl.identityPoolId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val nativeClientId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.nativeClientId())
    override val userPoolId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.userPoolId())
    override val webClientId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.webClientId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest
  ): zio.aws.amplifybackend.model.ImportBackendAuthRequest.ReadOnly =
    new Wrapper(impl)
}
