package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.{__double, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BackendAPIAppSyncAuthSettings(
    cognitoUserPoolId: Option[__string] = None,
    description: Option[__string] = None,
    expirationTime: Option[__double] = None,
    openIDAuthTTL: Option[__string] = None,
    openIDClientId: Option[__string] = None,
    openIDIatTTL: Option[__string] = None,
    openIDIssueURL: Option[__string] = None,
    openIDProviderName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendAPIAppSyncAuthSettings = {
    import BackendAPIAppSyncAuthSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIAppSyncAuthSettings
      .builder()
      .optionallyWith(
        cognitoUserPoolId.map(value => __string.unwrap(value): java.lang.String)
      )(_.cognitoUserPoolId)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        expirationTime.map(value => __double.unwrap(value): java.lang.Double)
      )(_.expirationTime)
      .optionallyWith(
        openIDAuthTTL.map(value => __string.unwrap(value): java.lang.String)
      )(_.openIDAuthTTL)
      .optionallyWith(
        openIDClientId.map(value => __string.unwrap(value): java.lang.String)
      )(_.openIDClientId)
      .optionallyWith(
        openIDIatTTL.map(value => __string.unwrap(value): java.lang.String)
      )(_.openIDIatTTL)
      .optionallyWith(
        openIDIssueURL.map(value => __string.unwrap(value): java.lang.String)
      )(_.openIDIssueURL)
      .optionallyWith(
        openIDProviderName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.openIDProviderName)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings.ReadOnly =
    zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings
      .wrap(buildAwsValue())
}
object BackendAPIAppSyncAuthSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIAppSyncAuthSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings =
      zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings(
        cognitoUserPoolId.map(value => value),
        description.map(value => value),
        expirationTime.map(value => value),
        openIDAuthTTL.map(value => value),
        openIDClientId.map(value => value),
        openIDIatTTL.map(value => value),
        openIDIssueURL.map(value => value),
        openIDProviderName.map(value => value)
      )
    def cognitoUserPoolId: Option[__string]
    def description: Option[__string]
    def expirationTime: Option[__double]
    def openIDAuthTTL: Option[__string]
    def openIDClientId: Option[__string]
    def openIDIatTTL: Option[__string]
    def openIDIssueURL: Option[__string]
    def openIDProviderName: Option[__string]
    def getCognitoUserPoolId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("cognitoUserPoolId", cognitoUserPoolId)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getExpirationTime: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getOpenIDAuthTTL: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("openIDAuthTTL", openIDAuthTTL)
    def getOpenIDClientId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("openIDClientId", openIDClientId)
    def getOpenIDIatTTL: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("openIDIatTTL", openIDIatTTL)
    def getOpenIDIssueURL: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("openIDIssueURL", openIDIssueURL)
    def getOpenIDProviderName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("openIDProviderName", openIDProviderName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIAppSyncAuthSettings
  ) extends zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings.ReadOnly {
    override val cognitoUserPoolId: Option[__string] = scala
      .Option(impl.cognitoUserPoolId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val expirationTime: Option[__double] = scala
      .Option(impl.expirationTime())
      .map(value => zio.aws.amplifybackend.model.primitives.__double(value))
    override val openIDAuthTTL: Option[__string] = scala
      .Option(impl.openIDAuthTTL())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val openIDClientId: Option[__string] = scala
      .Option(impl.openIDClientId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val openIDIatTTL: Option[__string] = scala
      .Option(impl.openIDIatTTL())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val openIDIssueURL: Option[__string] = scala
      .Option(impl.openIDIssueURL())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val openIDProviderName: Option[__string] = scala
      .Option(impl.openIDProviderName())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIAppSyncAuthSettings
  ): zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings.ReadOnly =
    new Wrapper(impl)
}
