package zio.aws.alexaforbusiness.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{
  Arn,
  DeviceLocale,
  ProfileName,
  MaxVolumeLimit,
  Address,
  Timezone
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateProfileRequest(
    profileArn: Optional[Arn] = Optional.Absent,
    profileName: Optional[ProfileName] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent,
    timezone: Optional[Timezone] = Optional.Absent,
    address: Optional[Address] = Optional.Absent,
    distanceUnit: Optional[zio.aws.alexaforbusiness.model.DistanceUnit] =
      Optional.Absent,
    temperatureUnit: Optional[zio.aws.alexaforbusiness.model.TemperatureUnit] =
      Optional.Absent,
    wakeWord: Optional[zio.aws.alexaforbusiness.model.WakeWord] =
      Optional.Absent,
    locale: Optional[DeviceLocale] = Optional.Absent,
    setupModeDisabled: Optional[Boolean] = Optional.Absent,
    maxVolumeLimit: Optional[MaxVolumeLimit] = Optional.Absent,
    pstnEnabled: Optional[Boolean] = Optional.Absent,
    dataRetentionOptIn: Optional[Boolean] = Optional.Absent,
    meetingRoomConfiguration: Optional[
      zio.aws.alexaforbusiness.model.UpdateMeetingRoomConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest = {
    import UpdateProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest
      .builder()
      .optionallyWith(
        profileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.profileArn)
      .optionallyWith(
        profileName.map(value => ProfileName.unwrap(value): java.lang.String)
      )(_.profileName)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(
        timezone.map(value => Timezone.unwrap(value): java.lang.String)
      )(_.timezone)
      .optionallyWith(
        address.map(value => Address.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(distanceUnit.map(value => value.unwrap))(_.distanceUnit)
      .optionallyWith(temperatureUnit.map(value => value.unwrap))(
        _.temperatureUnit
      )
      .optionallyWith(wakeWord.map(value => value.unwrap))(_.wakeWord)
      .optionallyWith(
        locale.map(value => DeviceLocale.unwrap(value): java.lang.String)
      )(_.locale)
      .optionallyWith(setupModeDisabled.map(value => value: java.lang.Boolean))(
        _.setupModeDisabled
      )
      .optionallyWith(
        maxVolumeLimit.map(value => MaxVolumeLimit.unwrap(value): Integer)
      )(_.maxVolumeLimit)
      .optionallyWith(pstnEnabled.map(value => value: java.lang.Boolean))(
        _.pstnEnabled
      )
      .optionallyWith(
        dataRetentionOptIn.map(value => value: java.lang.Boolean)
      )(_.dataRetentionOptIn)
      .optionallyWith(
        meetingRoomConfiguration.map(value => value.buildAwsValue())
      )(_.meetingRoomConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.UpdateProfileRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.UpdateProfileRequest.wrap(buildAwsValue())
}
object UpdateProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.UpdateProfileRequest =
      zio.aws.alexaforbusiness.model.UpdateProfileRequest(
        profileArn.map(value => value),
        profileName.map(value => value),
        isDefault.map(value => value),
        timezone.map(value => value),
        address.map(value => value),
        distanceUnit.map(value => value),
        temperatureUnit.map(value => value),
        wakeWord.map(value => value),
        locale.map(value => value),
        setupModeDisabled.map(value => value),
        maxVolumeLimit.map(value => value),
        pstnEnabled.map(value => value),
        dataRetentionOptIn.map(value => value),
        meetingRoomConfiguration.map(value => value.asEditable)
      )
    def profileArn: Optional[Arn]
    def profileName: Optional[ProfileName]
    def isDefault: Optional[Boolean]
    def timezone: Optional[Timezone]
    def address: Optional[Address]
    def distanceUnit: Optional[zio.aws.alexaforbusiness.model.DistanceUnit]
    def temperatureUnit
        : Optional[zio.aws.alexaforbusiness.model.TemperatureUnit]
    def wakeWord: Optional[zio.aws.alexaforbusiness.model.WakeWord]
    def locale: Optional[DeviceLocale]
    def setupModeDisabled: Optional[Boolean]
    def maxVolumeLimit: Optional[MaxVolumeLimit]
    def pstnEnabled: Optional[Boolean]
    def dataRetentionOptIn: Optional[Boolean]
    def meetingRoomConfiguration: Optional[
      zio.aws.alexaforbusiness.model.UpdateMeetingRoomConfiguration.ReadOnly
    ]
    def getProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("profileArn", profileArn)
    def getProfileName: ZIO[Any, AwsError, ProfileName] =
      AwsError.unwrapOptionField("profileName", profileName)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getTimezone: ZIO[Any, AwsError, Timezone] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getAddress: ZIO[Any, AwsError, Address] =
      AwsError.unwrapOptionField("address", address)
    def getDistanceUnit
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.DistanceUnit] =
      AwsError.unwrapOptionField("distanceUnit", distanceUnit)
    def getTemperatureUnit
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.TemperatureUnit] =
      AwsError.unwrapOptionField("temperatureUnit", temperatureUnit)
    def getWakeWord
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.WakeWord] =
      AwsError.unwrapOptionField("wakeWord", wakeWord)
    def getLocale: ZIO[Any, AwsError, DeviceLocale] =
      AwsError.unwrapOptionField("locale", locale)
    def getSetupModeDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("setupModeDisabled", setupModeDisabled)
    def getMaxVolumeLimit: ZIO[Any, AwsError, MaxVolumeLimit] =
      AwsError.unwrapOptionField("maxVolumeLimit", maxVolumeLimit)
    def getPstnEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("pstnEnabled", pstnEnabled)
    def getDataRetentionOptIn: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataRetentionOptIn", dataRetentionOptIn)
    def getMeetingRoomConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateMeetingRoomConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "meetingRoomConfiguration",
      meetingRoomConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest
  ) extends zio.aws.alexaforbusiness.model.UpdateProfileRequest.ReadOnly {
    override val profileArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.profileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val profileName: Optional[ProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.profileName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ProfileName(value)
      )
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
    override val timezone: Optional[Timezone] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Timezone(value))
    override val address: Optional[Address] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Address(value))
    override val distanceUnit
        : Optional[zio.aws.alexaforbusiness.model.DistanceUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distanceUnit())
        .map(value => zio.aws.alexaforbusiness.model.DistanceUnit.wrap(value))
    override val temperatureUnit
        : Optional[zio.aws.alexaforbusiness.model.TemperatureUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.temperatureUnit())
        .map(value =>
          zio.aws.alexaforbusiness.model.TemperatureUnit.wrap(value)
        )
    override val wakeWord: Optional[zio.aws.alexaforbusiness.model.WakeWord] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wakeWord())
        .map(value => zio.aws.alexaforbusiness.model.WakeWord.wrap(value))
    override val locale: Optional[DeviceLocale] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceLocale(value)
      )
    override val setupModeDisabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.setupModeDisabled())
      .map(value => value: Boolean)
    override val maxVolumeLimit: Optional[MaxVolumeLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxVolumeLimit())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.MaxVolumeLimit(value)
        )
    override val pstnEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.pstnEnabled())
      .map(value => value: Boolean)
    override val dataRetentionOptIn: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dataRetentionOptIn())
      .map(value => value: Boolean)
    override val meetingRoomConfiguration: Optional[
      zio.aws.alexaforbusiness.model.UpdateMeetingRoomConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.meetingRoomConfiguration())
      .map(value =>
        zio.aws.alexaforbusiness.model.UpdateMeetingRoomConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest
  ): zio.aws.alexaforbusiness.model.UpdateProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
