package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateMeetingRoomConfiguration(
    roomUtilizationMetricsEnabled: Optional[Boolean] = Optional.Absent,
    endOfMeetingReminder: Optional[
      zio.aws.alexaforbusiness.model.UpdateEndOfMeetingReminder
    ] = Optional.Absent,
    instantBooking: Optional[
      zio.aws.alexaforbusiness.model.UpdateInstantBooking
    ] = Optional.Absent,
    requireCheckIn: Optional[
      zio.aws.alexaforbusiness.model.UpdateRequireCheckIn
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UpdateMeetingRoomConfiguration = {
    import UpdateMeetingRoomConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateMeetingRoomConfiguration
      .builder()
      .optionallyWith(
        roomUtilizationMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.roomUtilizationMetricsEnabled)
      .optionallyWith(endOfMeetingReminder.map(value => value.buildAwsValue()))(
        _.endOfMeetingReminder
      )
      .optionallyWith(instantBooking.map(value => value.buildAwsValue()))(
        _.instantBooking
      )
      .optionallyWith(requireCheckIn.map(value => value.buildAwsValue()))(
        _.requireCheckIn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.UpdateMeetingRoomConfiguration.ReadOnly =
    zio.aws.alexaforbusiness.model.UpdateMeetingRoomConfiguration
      .wrap(buildAwsValue())
}
object UpdateMeetingRoomConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateMeetingRoomConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.UpdateMeetingRoomConfiguration =
      zio.aws.alexaforbusiness.model.UpdateMeetingRoomConfiguration(
        roomUtilizationMetricsEnabled.map(value => value),
        endOfMeetingReminder.map(value => value.asEditable),
        instantBooking.map(value => value.asEditable),
        requireCheckIn.map(value => value.asEditable)
      )
    def roomUtilizationMetricsEnabled: Optional[Boolean]
    def endOfMeetingReminder: Optional[
      zio.aws.alexaforbusiness.model.UpdateEndOfMeetingReminder.ReadOnly
    ]
    def instantBooking
        : Optional[zio.aws.alexaforbusiness.model.UpdateInstantBooking.ReadOnly]
    def requireCheckIn
        : Optional[zio.aws.alexaforbusiness.model.UpdateRequireCheckIn.ReadOnly]
    def getRoomUtilizationMetricsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "roomUtilizationMetricsEnabled",
        roomUtilizationMetricsEnabled
      )
    def getEndOfMeetingReminder: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateEndOfMeetingReminder.ReadOnly
    ] = AwsError.unwrapOptionField("endOfMeetingReminder", endOfMeetingReminder)
    def getInstantBooking: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateInstantBooking.ReadOnly
    ] = AwsError.unwrapOptionField("instantBooking", instantBooking)
    def getRequireCheckIn: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.UpdateRequireCheckIn.ReadOnly
    ] = AwsError.unwrapOptionField("requireCheckIn", requireCheckIn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateMeetingRoomConfiguration
  ) extends zio.aws.alexaforbusiness.model.UpdateMeetingRoomConfiguration.ReadOnly {
    override val roomUtilizationMetricsEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roomUtilizationMetricsEnabled())
        .map(value => value: Boolean)
    override val endOfMeetingReminder: Optional[
      zio.aws.alexaforbusiness.model.UpdateEndOfMeetingReminder.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endOfMeetingReminder())
      .map(value =>
        zio.aws.alexaforbusiness.model.UpdateEndOfMeetingReminder.wrap(value)
      )
    override val instantBooking: Optional[
      zio.aws.alexaforbusiness.model.UpdateInstantBooking.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instantBooking())
      .map(value =>
        zio.aws.alexaforbusiness.model.UpdateInstantBooking.wrap(value)
      )
    override val requireCheckIn: Optional[
      zio.aws.alexaforbusiness.model.UpdateRequireCheckIn.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requireCheckIn())
      .map(value =>
        zio.aws.alexaforbusiness.model.UpdateRequireCheckIn.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateMeetingRoomConfiguration
  ): zio.aws.alexaforbusiness.model.UpdateMeetingRoomConfiguration.ReadOnly =
    new Wrapper(impl)
}
