package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  BusinessReportScheduleName,
  S3KeyPrefix,
  CustomerS3BucketName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateBusinessReportScheduleRequest(
    scheduleArn: Arn,
    s3BucketName: Optional[CustomerS3BucketName] = Optional.Absent,
    s3KeyPrefix: Optional[S3KeyPrefix] = Optional.Absent,
    format: Optional[zio.aws.alexaforbusiness.model.BusinessReportFormat] =
      Optional.Absent,
    scheduleName: Optional[BusinessReportScheduleName] = Optional.Absent,
    recurrence: Optional[
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleRequest = {
    import UpdateBusinessReportScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleRequest
      .builder()
      .scheduleArn(Arn.unwrap(scheduleArn): java.lang.String)
      .optionallyWith(
        s3BucketName.map(value =>
          CustomerS3BucketName.unwrap(value): java.lang.String
        )
      )(_.s3BucketName)
      .optionallyWith(
        s3KeyPrefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        scheduleName.map(value =>
          BusinessReportScheduleName.unwrap(value): java.lang.String
        )
      )(_.scheduleName)
      .optionallyWith(recurrence.map(value => value.buildAwsValue()))(
        _.recurrence
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleRequest
      .wrap(buildAwsValue())
}
object UpdateBusinessReportScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleRequest =
      zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleRequest(
        scheduleArn,
        s3BucketName.map(value => value),
        s3KeyPrefix.map(value => value),
        format.map(value => value),
        scheduleName.map(value => value),
        recurrence.map(value => value.asEditable)
      )
    def scheduleArn: Arn
    def s3BucketName: Optional[CustomerS3BucketName]
    def s3KeyPrefix: Optional[S3KeyPrefix]
    def format: Optional[zio.aws.alexaforbusiness.model.BusinessReportFormat]
    def scheduleName: Optional[BusinessReportScheduleName]
    def recurrence: Optional[
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly
    ]
    def getScheduleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(scheduleArn)
    def getS3BucketName: ZIO[Any, AwsError, CustomerS3BucketName] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getFormat: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportFormat
    ] = AwsError.unwrapOptionField("format", format)
    def getScheduleName: ZIO[Any, AwsError, BusinessReportScheduleName] =
      AwsError.unwrapOptionField("scheduleName", scheduleName)
    def getRecurrence: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly
    ] = AwsError.unwrapOptionField("recurrence", recurrence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleRequest
  ) extends zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleRequest.ReadOnly {
    override val scheduleArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.scheduleArn())
    override val s3BucketName: Optional[CustomerS3BucketName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BucketName())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.CustomerS3BucketName(value)
        )
    override val s3KeyPrefix: Optional[S3KeyPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyPrefix())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.S3KeyPrefix(value)
      )
    override val format
        : Optional[zio.aws.alexaforbusiness.model.BusinessReportFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value =>
          zio.aws.alexaforbusiness.model.BusinessReportFormat.wrap(value)
        )
    override val scheduleName: Optional[BusinessReportScheduleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleName())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .BusinessReportScheduleName(value)
        )
    override val recurrence: Optional[
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recurrence())
      .map(value =>
        zio.aws.alexaforbusiness.model.BusinessReportRecurrence.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleRequest
  ): zio.aws.alexaforbusiness.model.UpdateBusinessReportScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
