package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListBusinessReportSchedulesResponse(
    businessReportSchedules: Optional[
      Iterable[zio.aws.alexaforbusiness.model.BusinessReportSchedule]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse = {
    import ListBusinessReportSchedulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse
      .builder()
      .optionallyWith(
        businessReportSchedules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.businessReportSchedules)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse
      .wrap(buildAwsValue())
}
object ListBusinessReportSchedulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse =
      zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse(
        businessReportSchedules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def businessReportSchedules: Optional[
      List[zio.aws.alexaforbusiness.model.BusinessReportSchedule.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getBusinessReportSchedules: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.BusinessReportSchedule.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "businessReportSchedules",
      businessReportSchedules
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse
  ) extends zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse.ReadOnly {
    override val businessReportSchedules: Optional[
      List[zio.aws.alexaforbusiness.model.BusinessReportSchedule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.businessReportSchedules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.BusinessReportSchedule.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse
  ): zio.aws.alexaforbusiness.model.ListBusinessReportSchedulesResponse.ReadOnly =
    new Wrapper(impl)
}
