package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceStatus {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus
}
object DeviceStatus {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus
  ): zio.aws.alexaforbusiness.model.DeviceStatus = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.WAS_OFFLINE =>
      val r = WAS_OFFLINE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.DEREGISTERED =>
      val r = DEREGISTERED
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object READY extends zio.aws.alexaforbusiness.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.READY
  }
  case object PENDING extends zio.aws.alexaforbusiness.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.PENDING
  }
  case object WAS_OFFLINE extends zio.aws.alexaforbusiness.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.WAS_OFFLINE
  }
  case object DEREGISTERED extends zio.aws.alexaforbusiness.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.DEREGISTERED
  }
  case object FAILED extends zio.aws.alexaforbusiness.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus.FAILED
  }
}
