package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ClientRequestToken,
  Email,
  User_LastName,
  User_FirstName,
  User_UserId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateUserRequest(
    userId: User_UserId,
    firstName: Optional[User_FirstName] = Optional.Absent,
    lastName: Optional[User_LastName] = Optional.Absent,
    email: Optional[Email] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.alexaforbusiness.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest
      .builder()
      .userId(User_UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        firstName.map(value => User_FirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => User_LastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.CreateUserRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateUserRequest.wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateUserRequest =
      zio.aws.alexaforbusiness.model.CreateUserRequest(
        userId,
        firstName.map(value => value),
        lastName.map(value => value),
        email.map(value => value),
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def userId: User_UserId
    def firstName: Optional[User_FirstName]
    def lastName: Optional[User_LastName]
    def email: Optional[Email]
    def clientRequestToken: Optional[ClientRequestToken]
    def tags: Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]]
    def getUserId: ZIO[Any, Nothing, User_UserId] = ZIO.succeed(userId)
    def getFirstName: ZIO[Any, AwsError, User_FirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, User_LastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest
  ) extends zio.aws.alexaforbusiness.model.CreateUserRequest.ReadOnly {
    override val userId: User_UserId =
      zio.aws.alexaforbusiness.model.primitives.User_UserId(impl.userId())
    override val firstName: Optional[User_FirstName] = zio.aws.core.internal
      .optionalFromNullable(impl.firstName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.User_FirstName(value)
      )
    override val lastName: Optional[User_LastName] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.User_LastName(value)
      )
    override val email: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Email(value))
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.ClientRequestToken(value)
        )
    override val tags
        : Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest
  ): zio.aws.alexaforbusiness.model.CreateUserRequest.ReadOnly = new Wrapper(
    impl
  )
}
