package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait BusinessReportInterval {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval
}
object BusinessReportInterval {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval
  ): zio.aws.alexaforbusiness.model.BusinessReportInterval = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval.ONE_DAY =>
      val r = ONE_DAY
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval.ONE_WEEK =>
      val r = ONE_WEEK
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval.THIRTY_DAYS =>
      val r = THIRTY_DAYS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.BusinessReportInterval {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval.UNKNOWN_TO_SDK_VERSION
  }
  case object ONE_DAY
      extends zio.aws.alexaforbusiness.model.BusinessReportInterval {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval.ONE_DAY
  }
  case object ONE_WEEK
      extends zio.aws.alexaforbusiness.model.BusinessReportInterval {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval.ONE_WEEK
  }
  case object THIRTY_DAYS
      extends zio.aws.alexaforbusiness.model.BusinessReportInterval {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportInterval.THIRTY_DAYS
  }
}
