package zio.aws.alexaforbusiness.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{TotalCount, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchProfilesResponse(
    profiles: Optional[Iterable[zio.aws.alexaforbusiness.model.ProfileData]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    totalCount: Optional[TotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse = {
    import SearchProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse
      .builder()
      .optionallyWith(
        profiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.profiles)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        totalCount.map(value => TotalCount.unwrap(value): Integer)
      )(_.totalCount)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.SearchProfilesResponse.wrap(buildAwsValue())
}
object SearchProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SearchProfilesResponse =
      zio.aws.alexaforbusiness.model.SearchProfilesResponse(
        profiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        totalCount.map(value => value)
      )
    def profiles
        : Optional[List[zio.aws.alexaforbusiness.model.ProfileData.ReadOnly]]
    def nextToken: Optional[NextToken]
    def totalCount: Optional[TotalCount]
    def getProfiles: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.ProfileData.ReadOnly
    ]] = AwsError.unwrapOptionField("profiles", profiles)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalCount: ZIO[Any, AwsError, TotalCount] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse
  ) extends zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly {
    override val profiles
        : Optional[List[zio.aws.alexaforbusiness.model.ProfileData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.ProfileData.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val totalCount: Optional[TotalCount] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => zio.aws.alexaforbusiness.model.primitives.TotalCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse
  ): zio.aws.alexaforbusiness.model.SearchProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
