package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{EnrollmentId, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RevokeInvitationRequest(
    userArn: Optional[Arn] = Optional.Absent,
    enrollmentId: Optional[EnrollmentId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest = {
    import RevokeInvitationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest
      .builder()
      .optionallyWith(
        userArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        enrollmentId.map(value => EnrollmentId.unwrap(value): java.lang.String)
      )(_.enrollmentId)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.RevokeInvitationRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.RevokeInvitationRequest.wrap(buildAwsValue())
}
object RevokeInvitationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.RevokeInvitationRequest =
      zio.aws.alexaforbusiness.model.RevokeInvitationRequest(
        userArn.map(value => value),
        enrollmentId.map(value => value)
      )
    def userArn: Optional[Arn]
    def enrollmentId: Optional[EnrollmentId]
    def getUserArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getEnrollmentId: ZIO[Any, AwsError, EnrollmentId] =
      AwsError.unwrapOptionField("enrollmentId", enrollmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest
  ) extends zio.aws.alexaforbusiness.model.RevokeInvitationRequest.ReadOnly {
    override val userArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val enrollmentId: Optional[EnrollmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.enrollmentId())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.EnrollmentId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest
  ): zio.aws.alexaforbusiness.model.RevokeInvitationRequest.ReadOnly =
    new Wrapper(impl)
}
