package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait RequirePin {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.RequirePin
}
object RequirePin {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.RequirePin
  ): zio.aws.alexaforbusiness.model.RequirePin = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.RequirePin.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.RequirePin.YES =>
      val r = YES
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.RequirePin.NO =>
      val r = NO
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.RequirePin.OPTIONAL =>
      val r = OPTIONAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.RequirePin {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.RequirePin =
      software.amazon.awssdk.services.alexaforbusiness.model.RequirePin.UNKNOWN_TO_SDK_VERSION
  }
  case object YES extends zio.aws.alexaforbusiness.model.RequirePin {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.RequirePin =
      software.amazon.awssdk.services.alexaforbusiness.model.RequirePin.YES
  }
  case object NO extends zio.aws.alexaforbusiness.model.RequirePin {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.RequirePin =
      software.amazon.awssdk.services.alexaforbusiness.model.RequirePin.NO
  }
  case object OPTIONAL extends zio.aws.alexaforbusiness.model.RequirePin {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.RequirePin =
      software.amazon.awssdk.services.alexaforbusiness.model.RequirePin.OPTIONAL
  }
}
