package zio.aws.alexaforbusiness.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.Minutes
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RequireCheckIn(
    releaseAfterMinutes: Optional[Minutes] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.RequireCheckIn = {
    import RequireCheckIn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.RequireCheckIn
      .builder()
      .optionallyWith(
        releaseAfterMinutes.map(value => Minutes.unwrap(value): Integer)
      )(_.releaseAfterMinutes)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly =
    zio.aws.alexaforbusiness.model.RequireCheckIn.wrap(buildAwsValue())
}
object RequireCheckIn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.RequireCheckIn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.RequireCheckIn =
      zio.aws.alexaforbusiness.model.RequireCheckIn(
        releaseAfterMinutes.map(value => value),
        enabled.map(value => value)
      )
    def releaseAfterMinutes: Optional[Minutes]
    def enabled: Optional[Boolean]
    def getReleaseAfterMinutes: ZIO[Any, AwsError, Minutes] =
      AwsError.unwrapOptionField("releaseAfterMinutes", releaseAfterMinutes)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RequireCheckIn
  ) extends zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly {
    override val releaseAfterMinutes: Optional[Minutes] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseAfterMinutes())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Minutes(value))
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RequireCheckIn
  ): zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly = new Wrapper(impl)
}
