package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListGatewayGroupsResponse(
    gatewayGroups: Optional[
      Iterable[zio.aws.alexaforbusiness.model.GatewayGroupSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse = {
    import ListGatewayGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse
      .builder()
      .optionallyWith(
        gatewayGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gatewayGroups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse
      .wrap(buildAwsValue())
}
object ListGatewayGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse =
      zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse(
        gatewayGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def gatewayGroups: Optional[
      List[zio.aws.alexaforbusiness.model.GatewayGroupSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getGatewayGroups: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.GatewayGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("gatewayGroups", gatewayGroups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse
  ) extends zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse.ReadOnly {
    override val gatewayGroups: Optional[
      List[zio.aws.alexaforbusiness.model.GatewayGroupSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.GatewayGroupSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse
  ): zio.aws.alexaforbusiness.model.ListGatewayGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
