package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ClientRequestToken,
  Arn,
  NextWiFiPassword,
  NetworkProfileDescription,
  NetworkSsid,
  TrustAnchor,
  CurrentWiFiPassword,
  NetworkProfileName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateNetworkProfileRequest(
    networkProfileName: NetworkProfileName,
    description: Optional[NetworkProfileDescription] = Optional.Absent,
    ssid: NetworkSsid,
    securityType: zio.aws.alexaforbusiness.model.NetworkSecurityType,
    eapMethod: Optional[zio.aws.alexaforbusiness.model.NetworkEapMethod] =
      Optional.Absent,
    currentPassword: Optional[CurrentWiFiPassword] = Optional.Absent,
    nextPassword: Optional[NextWiFiPassword] = Optional.Absent,
    certificateAuthorityArn: Optional[Arn] = Optional.Absent,
    trustAnchors: Optional[Iterable[TrustAnchor]] = Optional.Absent,
    clientRequestToken: ClientRequestToken,
    tags: Optional[Iterable[zio.aws.alexaforbusiness.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileRequest = {
    import CreateNetworkProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileRequest
      .builder()
      .networkProfileName(
        NetworkProfileName.unwrap(networkProfileName): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          NetworkProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .ssid(NetworkSsid.unwrap(ssid): java.lang.String)
      .securityType(securityType.unwrap)
      .optionallyWith(eapMethod.map(value => value.unwrap))(_.eapMethod)
      .optionallyWith(
        currentPassword.map(value =>
          CurrentWiFiPassword.unwrap(value): java.lang.String
        )
      )(_.currentPassword)
      .optionallyWith(
        nextPassword.map(value =>
          NextWiFiPassword.unwrap(value): java.lang.String
        )
      )(_.nextPassword)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .optionallyWith(
        trustAnchors.map(value =>
          value.map { item =>
            TrustAnchor.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trustAnchors)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateNetworkProfileRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateNetworkProfileRequest
      .wrap(buildAwsValue())
}
object CreateNetworkProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateNetworkProfileRequest =
      zio.aws.alexaforbusiness.model.CreateNetworkProfileRequest(
        networkProfileName,
        description.map(value => value),
        ssid,
        securityType,
        eapMethod.map(value => value),
        currentPassword.map(value => value),
        nextPassword.map(value => value),
        certificateAuthorityArn.map(value => value),
        trustAnchors.map(value => value),
        clientRequestToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkProfileName: NetworkProfileName
    def description: Optional[NetworkProfileDescription]
    def ssid: NetworkSsid
    def securityType: zio.aws.alexaforbusiness.model.NetworkSecurityType
    def eapMethod: Optional[zio.aws.alexaforbusiness.model.NetworkEapMethod]
    def currentPassword: Optional[CurrentWiFiPassword]
    def nextPassword: Optional[NextWiFiPassword]
    def certificateAuthorityArn: Optional[Arn]
    def trustAnchors: Optional[List[TrustAnchor]]
    def clientRequestToken: ClientRequestToken
    def tags: Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]]
    def getNetworkProfileName: ZIO[Any, Nothing, NetworkProfileName] =
      ZIO.succeed(networkProfileName)
    def getDescription: ZIO[Any, AwsError, NetworkProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSsid: ZIO[Any, Nothing, NetworkSsid] = ZIO.succeed(ssid)
    def getSecurityType: ZIO[
      Any,
      Nothing,
      zio.aws.alexaforbusiness.model.NetworkSecurityType
    ] = ZIO.succeed(securityType)
    def getEapMethod
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.NetworkEapMethod] =
      AwsError.unwrapOptionField("eapMethod", eapMethod)
    def getCurrentPassword: ZIO[Any, AwsError, CurrentWiFiPassword] =
      AwsError.unwrapOptionField("currentPassword", currentPassword)
    def getNextPassword: ZIO[Any, AwsError, NextWiFiPassword] =
      AwsError.unwrapOptionField("nextPassword", nextPassword)
    def getCertificateAuthorityArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
    def getTrustAnchors: ZIO[Any, AwsError, List[TrustAnchor]] =
      AwsError.unwrapOptionField("trustAnchors", trustAnchors)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileRequest
  ) extends zio.aws.alexaforbusiness.model.CreateNetworkProfileRequest.ReadOnly {
    override val networkProfileName: NetworkProfileName =
      zio.aws.alexaforbusiness.model.primitives
        .NetworkProfileName(impl.networkProfileName())
    override val description: Optional[NetworkProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .NetworkProfileDescription(value)
        )
    override val ssid: NetworkSsid =
      zio.aws.alexaforbusiness.model.primitives.NetworkSsid(impl.ssid())
    override val securityType
        : zio.aws.alexaforbusiness.model.NetworkSecurityType =
      zio.aws.alexaforbusiness.model.NetworkSecurityType
        .wrap(impl.securityType())
    override val eapMethod
        : Optional[zio.aws.alexaforbusiness.model.NetworkEapMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eapMethod())
        .map(value =>
          zio.aws.alexaforbusiness.model.NetworkEapMethod.wrap(value)
        )
    override val currentPassword: Optional[CurrentWiFiPassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentPassword())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.CurrentWiFiPassword(value)
        )
    override val nextPassword: Optional[NextWiFiPassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextPassword())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.NextWiFiPassword(value)
        )
    override val certificateAuthorityArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateAuthorityArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val trustAnchors: Optional[List[TrustAnchor]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustAnchors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.primitives.TrustAnchor(item)
          }.toList
        )
    override val clientRequestToken: ClientRequestToken =
      zio.aws.alexaforbusiness.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val tags
        : Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileRequest
  ): zio.aws.alexaforbusiness.model.CreateNetworkProfileRequest.ReadOnly =
    new Wrapper(impl)
}
