package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMeetingRoomConfiguration(
    roomUtilizationMetricsEnabled: Optional[Boolean] = Optional.Absent,
    endOfMeetingReminder: Optional[
      zio.aws.alexaforbusiness.model.CreateEndOfMeetingReminder
    ] = Optional.Absent,
    instantBooking: Optional[
      zio.aws.alexaforbusiness.model.CreateInstantBooking
    ] = Optional.Absent,
    requireCheckIn: Optional[
      zio.aws.alexaforbusiness.model.CreateRequireCheckIn
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateMeetingRoomConfiguration = {
    import CreateMeetingRoomConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateMeetingRoomConfiguration
      .builder()
      .optionallyWith(
        roomUtilizationMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.roomUtilizationMetricsEnabled)
      .optionallyWith(endOfMeetingReminder.map(value => value.buildAwsValue()))(
        _.endOfMeetingReminder
      )
      .optionallyWith(instantBooking.map(value => value.buildAwsValue()))(
        _.instantBooking
      )
      .optionallyWith(requireCheckIn.map(value => value.buildAwsValue()))(
        _.requireCheckIn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateMeetingRoomConfiguration.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateMeetingRoomConfiguration
      .wrap(buildAwsValue())
}
object CreateMeetingRoomConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateMeetingRoomConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.CreateMeetingRoomConfiguration =
      zio.aws.alexaforbusiness.model.CreateMeetingRoomConfiguration(
        roomUtilizationMetricsEnabled.map(value => value),
        endOfMeetingReminder.map(value => value.asEditable),
        instantBooking.map(value => value.asEditable),
        requireCheckIn.map(value => value.asEditable)
      )
    def roomUtilizationMetricsEnabled: Optional[Boolean]
    def endOfMeetingReminder: Optional[
      zio.aws.alexaforbusiness.model.CreateEndOfMeetingReminder.ReadOnly
    ]
    def instantBooking
        : Optional[zio.aws.alexaforbusiness.model.CreateInstantBooking.ReadOnly]
    def requireCheckIn
        : Optional[zio.aws.alexaforbusiness.model.CreateRequireCheckIn.ReadOnly]
    def getRoomUtilizationMetricsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "roomUtilizationMetricsEnabled",
        roomUtilizationMetricsEnabled
      )
    def getEndOfMeetingReminder: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.CreateEndOfMeetingReminder.ReadOnly
    ] = AwsError.unwrapOptionField("endOfMeetingReminder", endOfMeetingReminder)
    def getInstantBooking: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.CreateInstantBooking.ReadOnly
    ] = AwsError.unwrapOptionField("instantBooking", instantBooking)
    def getRequireCheckIn: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.CreateRequireCheckIn.ReadOnly
    ] = AwsError.unwrapOptionField("requireCheckIn", requireCheckIn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateMeetingRoomConfiguration
  ) extends zio.aws.alexaforbusiness.model.CreateMeetingRoomConfiguration.ReadOnly {
    override val roomUtilizationMetricsEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roomUtilizationMetricsEnabled())
        .map(value => value: Boolean)
    override val endOfMeetingReminder: Optional[
      zio.aws.alexaforbusiness.model.CreateEndOfMeetingReminder.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endOfMeetingReminder())
      .map(value =>
        zio.aws.alexaforbusiness.model.CreateEndOfMeetingReminder.wrap(value)
      )
    override val instantBooking: Optional[
      zio.aws.alexaforbusiness.model.CreateInstantBooking.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instantBooking())
      .map(value =>
        zio.aws.alexaforbusiness.model.CreateInstantBooking.wrap(value)
      )
    override val requireCheckIn: Optional[
      zio.aws.alexaforbusiness.model.CreateRequireCheckIn.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requireCheckIn())
      .map(value =>
        zio.aws.alexaforbusiness.model.CreateRequireCheckIn.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateMeetingRoomConfiguration
  ): zio.aws.alexaforbusiness.model.CreateMeetingRoomConfiguration.ReadOnly =
    new Wrapper(impl)
}
