package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ClientRequestToken,
  ConferenceProviderName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConferenceProviderRequest(
    conferenceProviderName: ConferenceProviderName,
    conferenceProviderType: zio.aws.alexaforbusiness.model.ConferenceProviderType,
    ipDialIn: Optional[zio.aws.alexaforbusiness.model.IPDialIn] =
      Optional.Absent,
    pstnDialIn: Optional[zio.aws.alexaforbusiness.model.PSTNDialIn] =
      Optional.Absent,
    meetingSetting: zio.aws.alexaforbusiness.model.MeetingSetting,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.alexaforbusiness.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderRequest = {
    import CreateConferenceProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderRequest
      .builder()
      .conferenceProviderName(
        ConferenceProviderName.unwrap(conferenceProviderName): java.lang.String
      )
      .conferenceProviderType(conferenceProviderType.unwrap)
      .optionallyWith(ipDialIn.map(value => value.buildAwsValue()))(_.ipDialIn)
      .optionallyWith(pstnDialIn.map(value => value.buildAwsValue()))(
        _.pstnDialIn
      )
      .meetingSetting(meetingSetting.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateConferenceProviderRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateConferenceProviderRequest
      .wrap(buildAwsValue())
}
object CreateConferenceProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.CreateConferenceProviderRequest =
      zio.aws.alexaforbusiness.model.CreateConferenceProviderRequest(
        conferenceProviderName,
        conferenceProviderType,
        ipDialIn.map(value => value.asEditable),
        pstnDialIn.map(value => value.asEditable),
        meetingSetting.asEditable,
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def conferenceProviderName: ConferenceProviderName
    def conferenceProviderType
        : zio.aws.alexaforbusiness.model.ConferenceProviderType
    def ipDialIn: Optional[zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly]
    def pstnDialIn: Optional[zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly]
    def meetingSetting: zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly
    def clientRequestToken: Optional[ClientRequestToken]
    def tags: Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]]
    def getConferenceProviderName: ZIO[Any, Nothing, ConferenceProviderName] =
      ZIO.succeed(conferenceProviderName)
    def getConferenceProviderType: ZIO[
      Any,
      Nothing,
      zio.aws.alexaforbusiness.model.ConferenceProviderType
    ] = ZIO.succeed(conferenceProviderType)
    def getIpDialIn
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly] =
      AwsError.unwrapOptionField("ipDialIn", ipDialIn)
    def getPstnDialIn: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly
    ] = AwsError.unwrapOptionField("pstnDialIn", pstnDialIn)
    def getMeetingSetting: ZIO[
      Any,
      Nothing,
      zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly
    ] = ZIO.succeed(meetingSetting)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderRequest
  ) extends zio.aws.alexaforbusiness.model.CreateConferenceProviderRequest.ReadOnly {
    override val conferenceProviderName: ConferenceProviderName =
      zio.aws.alexaforbusiness.model.primitives
        .ConferenceProviderName(impl.conferenceProviderName())
    override val conferenceProviderType
        : zio.aws.alexaforbusiness.model.ConferenceProviderType =
      zio.aws.alexaforbusiness.model.ConferenceProviderType
        .wrap(impl.conferenceProviderType())
    override val ipDialIn
        : Optional[zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipDialIn())
        .map(value => zio.aws.alexaforbusiness.model.IPDialIn.wrap(value))
    override val pstnDialIn
        : Optional[zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pstnDialIn())
        .map(value => zio.aws.alexaforbusiness.model.PSTNDialIn.wrap(value))
    override val meetingSetting
        : zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly =
      zio.aws.alexaforbusiness.model.MeetingSetting.wrap(impl.meetingSetting())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.ClientRequestToken(value)
        )
    override val tags
        : Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderRequest
  ): zio.aws.alexaforbusiness.model.CreateConferenceProviderRequest.ReadOnly =
    new Wrapper(impl)
}
