package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BusinessReportRecurrence(
    startDate: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportRecurrence = {
    import BusinessReportRecurrence.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportRecurrence
      .builder()
      .optionallyWith(
        startDate.map(value => Date.unwrap(value): java.lang.String)
      )(_.startDate)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly =
    zio.aws.alexaforbusiness.model.BusinessReportRecurrence
      .wrap(buildAwsValue())
}
object BusinessReportRecurrence {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportRecurrence
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.BusinessReportRecurrence =
      zio.aws.alexaforbusiness.model
        .BusinessReportRecurrence(startDate.map(value => value))
    def startDate: Optional[Date]
    def getStartDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startDate", startDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportRecurrence
  ) extends zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly {
    override val startDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportRecurrence
  ): zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly =
    new Wrapper(impl)
}
