package zio.aws.alexaforbusiness
import zio.prelude.Subtype
import zio.aws.alexaforbusiness.model.primitives.{
  Key,
  Minutes,
  SkillId,
  ReviewValue,
  ReviewKey,
  GenericKeyword,
  SkillStoreType,
  Value,
  BulletPoint,
  TrustAnchor,
  FilterValue,
  Utterance,
  TagKey
}
import java.time.Instant
import zio.aws.alexaforbusiness.model.primitives.BusinessReportDeliveryTime.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Address extends Subtype[String]
    type Address = zio.aws.alexaforbusiness.model.primitives.Address.Type
    object AddressBookDescription extends Subtype[String]
    type AddressBookDescription =
      zio.aws.alexaforbusiness.model.primitives.AddressBookDescription.Type
    object AddressBookName extends Subtype[String]
    type AddressBookName =
      zio.aws.alexaforbusiness.model.primitives.AddressBookName.Type
    object AmazonId extends Subtype[String]
    type AmazonId = zio.aws.alexaforbusiness.model.primitives.AmazonId.Type
    object ApplianceDescription extends Subtype[String]
    type ApplianceDescription =
      zio.aws.alexaforbusiness.model.primitives.ApplianceDescription.Type
    object ApplianceFriendlyName extends Subtype[String]
    type ApplianceFriendlyName =
      zio.aws.alexaforbusiness.model.primitives.ApplianceFriendlyName.Type
    object ApplianceManufacturerName extends Subtype[String]
    type ApplianceManufacturerName =
      zio.aws.alexaforbusiness.model.primitives.ApplianceManufacturerName.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.alexaforbusiness.model.primitives.Arn.Type
    object AudioLocation extends Subtype[String]
    type AudioLocation =
      zio.aws.alexaforbusiness.model.primitives.AudioLocation.Type
    object BulletPoint extends Subtype[String]
    type BulletPoint =
      zio.aws.alexaforbusiness.model.primitives.BulletPoint.Type
    object BusinessReportDeliveryTime extends Subtype[Instant]
    type BusinessReportDeliveryTime =
      zio.aws.alexaforbusiness.model.primitives.BusinessReportDeliveryTime.Type
    object BusinessReportDownloadUrl extends Subtype[String]
    type BusinessReportDownloadUrl =
      zio.aws.alexaforbusiness.model.primitives.BusinessReportDownloadUrl.Type
    object BusinessReportS3Path extends Subtype[String]
    type BusinessReportS3Path =
      zio.aws.alexaforbusiness.model.primitives.BusinessReportS3Path.Type
    object BusinessReportScheduleName extends Subtype[String]
    type BusinessReportScheduleName =
      zio.aws.alexaforbusiness.model.primitives.BusinessReportScheduleName.Type
    object CategoryId extends Subtype[Long]
    type CategoryId = zio.aws.alexaforbusiness.model.primitives.CategoryId.Type
    object CategoryName extends Subtype[String]
    type CategoryName =
      zio.aws.alexaforbusiness.model.primitives.CategoryName.Type
    object CertificateTime extends Subtype[Instant]
    type CertificateTime =
      zio.aws.alexaforbusiness.model.primitives.CertificateTime.Type
    object ClientId extends Subtype[String]
    type ClientId = zio.aws.alexaforbusiness.model.primitives.ClientId.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.alexaforbusiness.model.primitives.ClientRequestToken.Type
    object ConferenceProviderName extends Subtype[String]
    type ConferenceProviderName =
      zio.aws.alexaforbusiness.model.primitives.ConferenceProviderName.Type
    object ConnectionStatusUpdatedTime extends Subtype[Instant]
    type ConnectionStatusUpdatedTime =
      zio.aws.alexaforbusiness.model.primitives.ConnectionStatusUpdatedTime.Type
    object ContactName extends Subtype[String]
    type ContactName =
      zio.aws.alexaforbusiness.model.primitives.ContactName.Type
    object CountryCode extends Subtype[String]
    type CountryCode =
      zio.aws.alexaforbusiness.model.primitives.CountryCode.Type
    object CurrentWiFiPassword extends Subtype[String]
    type CurrentWiFiPassword =
      zio.aws.alexaforbusiness.model.primitives.CurrentWiFiPassword.Type
    object CustomerS3BucketName extends Subtype[String]
    type CustomerS3BucketName =
      zio.aws.alexaforbusiness.model.primitives.CustomerS3BucketName.Type
    object Date extends Subtype[String]
    type Date = zio.aws.alexaforbusiness.model.primitives.Date.Type
    object DeveloperName extends Subtype[String]
    type DeveloperName =
      zio.aws.alexaforbusiness.model.primitives.DeveloperName.Type
    object DeviceDataCreatedTime extends Subtype[Instant]
    type DeviceDataCreatedTime =
      zio.aws.alexaforbusiness.model.primitives.DeviceDataCreatedTime.Type
    object DeviceEventTime extends Subtype[Instant]
    type DeviceEventTime =
      zio.aws.alexaforbusiness.model.primitives.DeviceEventTime.Type
    object DeviceEventValue extends Subtype[String]
    type DeviceEventValue =
      zio.aws.alexaforbusiness.model.primitives.DeviceEventValue.Type
    object DeviceLocale extends Subtype[String]
    type DeviceLocale =
      zio.aws.alexaforbusiness.model.primitives.DeviceLocale.Type
    object DeviceName extends Subtype[String]
    type DeviceName = zio.aws.alexaforbusiness.model.primitives.DeviceName.Type
    object DeviceRoomName extends Subtype[String]
    type DeviceRoomName =
      zio.aws.alexaforbusiness.model.primitives.DeviceRoomName.Type
    object DeviceSerialNumber extends Subtype[String]
    type DeviceSerialNumber =
      zio.aws.alexaforbusiness.model.primitives.DeviceSerialNumber.Type
    object DeviceSerialNumberForAVS extends Subtype[String]
    type DeviceSerialNumberForAVS =
      zio.aws.alexaforbusiness.model.primitives.DeviceSerialNumberForAVS.Type
    object DeviceType extends Subtype[String]
    type DeviceType = zio.aws.alexaforbusiness.model.primitives.DeviceType.Type
    object Email extends Subtype[String]
    type Email = zio.aws.alexaforbusiness.model.primitives.Email.Type
    object EndUserLicenseAgreement extends Subtype[String]
    type EndUserLicenseAgreement =
      zio.aws.alexaforbusiness.model.primitives.EndUserLicenseAgreement.Type
    object Endpoint extends Subtype[String]
    type Endpoint = zio.aws.alexaforbusiness.model.primitives.Endpoint.Type
    object EnrollmentId extends Subtype[String]
    type EnrollmentId =
      zio.aws.alexaforbusiness.model.primitives.EnrollmentId.Type
    object FilterKey extends Subtype[String]
    type FilterKey = zio.aws.alexaforbusiness.model.primitives.FilterKey.Type
    object FilterValue extends Subtype[String]
    type FilterValue =
      zio.aws.alexaforbusiness.model.primitives.FilterValue.Type
    object GatewayDescription extends Subtype[String]
    type GatewayDescription =
      zio.aws.alexaforbusiness.model.primitives.GatewayDescription.Type
    object GatewayGroupDescription extends Subtype[String]
    type GatewayGroupDescription =
      zio.aws.alexaforbusiness.model.primitives.GatewayGroupDescription.Type
    object GatewayGroupName extends Subtype[String]
    type GatewayGroupName =
      zio.aws.alexaforbusiness.model.primitives.GatewayGroupName.Type
    object GatewayName extends Subtype[String]
    type GatewayName =
      zio.aws.alexaforbusiness.model.primitives.GatewayName.Type
    object GatewayVersion extends Subtype[String]
    type GatewayVersion =
      zio.aws.alexaforbusiness.model.primitives.GatewayVersion.Type
    object GenericKeyword extends Subtype[String]
    type GenericKeyword =
      zio.aws.alexaforbusiness.model.primitives.GenericKeyword.Type
    object IconUrl extends Subtype[String]
    type IconUrl = zio.aws.alexaforbusiness.model.primitives.IconUrl.Type
    object InvocationPhrase extends Subtype[String]
    type InvocationPhrase =
      zio.aws.alexaforbusiness.model.primitives.InvocationPhrase.Type
    object Key extends Subtype[String]
    type Key = zio.aws.alexaforbusiness.model.primitives.Key.Type
    object MacAddress extends Subtype[String]
    type MacAddress = zio.aws.alexaforbusiness.model.primitives.MacAddress.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.alexaforbusiness.model.primitives.MaxResults.Type
    object MaxVolumeLimit extends Subtype[Int]
    type MaxVolumeLimit =
      zio.aws.alexaforbusiness.model.primitives.MaxVolumeLimit.Type
    object Minutes extends Subtype[Int]
    type Minutes = zio.aws.alexaforbusiness.model.primitives.Minutes.Type
    object NetworkProfileDescription extends Subtype[String]
    type NetworkProfileDescription =
      zio.aws.alexaforbusiness.model.primitives.NetworkProfileDescription.Type
    object NetworkProfileName extends Subtype[String]
    type NetworkProfileName =
      zio.aws.alexaforbusiness.model.primitives.NetworkProfileName.Type
    object NetworkSsid extends Subtype[String]
    type NetworkSsid =
      zio.aws.alexaforbusiness.model.primitives.NetworkSsid.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.alexaforbusiness.model.primitives.NextToken.Type
    object NextWiFiPassword extends Subtype[String]
    type NextWiFiPassword =
      zio.aws.alexaforbusiness.model.primitives.NextWiFiPassword.Type
    object OneClickIdDelay extends Subtype[String]
    type OneClickIdDelay =
      zio.aws.alexaforbusiness.model.primitives.OneClickIdDelay.Type
    object OneClickPinDelay extends Subtype[String]
    type OneClickPinDelay =
      zio.aws.alexaforbusiness.model.primitives.OneClickPinDelay.Type
    object OrganizationName extends Subtype[String]
    type OrganizationName =
      zio.aws.alexaforbusiness.model.primitives.OrganizationName.Type
    object OutboundPhoneNumber extends Subtype[String]
    type OutboundPhoneNumber =
      zio.aws.alexaforbusiness.model.primitives.OutboundPhoneNumber.Type
    object PrivacyPolicy extends Subtype[String]
    type PrivacyPolicy =
      zio.aws.alexaforbusiness.model.primitives.PrivacyPolicy.Type
    object ProductDescription extends Subtype[String]
    type ProductDescription =
      zio.aws.alexaforbusiness.model.primitives.ProductDescription.Type
    object ProductId extends Subtype[String]
    type ProductId = zio.aws.alexaforbusiness.model.primitives.ProductId.Type
    object ProfileName extends Subtype[String]
    type ProfileName =
      zio.aws.alexaforbusiness.model.primitives.ProfileName.Type
    object ProviderCalendarId extends Subtype[String]
    type ProviderCalendarId =
      zio.aws.alexaforbusiness.model.primitives.ProviderCalendarId.Type
    object RawPhoneNumber extends Subtype[String]
    type RawPhoneNumber =
      zio.aws.alexaforbusiness.model.primitives.RawPhoneNumber.Type
    object ReleaseDate extends Subtype[String]
    type ReleaseDate =
      zio.aws.alexaforbusiness.model.primitives.ReleaseDate.Type
    object ReviewKey extends Subtype[String]
    type ReviewKey = zio.aws.alexaforbusiness.model.primitives.ReviewKey.Type
    object ReviewValue extends Subtype[String]
    type ReviewValue =
      zio.aws.alexaforbusiness.model.primitives.ReviewValue.Type
    object RoomDescription extends Subtype[String]
    type RoomDescription =
      zio.aws.alexaforbusiness.model.primitives.RoomDescription.Type
    object RoomName extends Subtype[String]
    type RoomName = zio.aws.alexaforbusiness.model.primitives.RoomName.Type
    object RoomSkillParameterKey extends Subtype[String]
    type RoomSkillParameterKey =
      zio.aws.alexaforbusiness.model.primitives.RoomSkillParameterKey.Type
    object RoomSkillParameterValue extends Subtype[String]
    type RoomSkillParameterValue =
      zio.aws.alexaforbusiness.model.primitives.RoomSkillParameterValue.Type
    object S3KeyPrefix extends Subtype[String]
    type S3KeyPrefix =
      zio.aws.alexaforbusiness.model.primitives.S3KeyPrefix.Type
    object ShortDescription extends Subtype[String]
    type ShortDescription =
      zio.aws.alexaforbusiness.model.primitives.ShortDescription.Type
    object SipUri extends Subtype[String]
    type SipUri = zio.aws.alexaforbusiness.model.primitives.SipUri.Type
    object SkillGroupDescription extends Subtype[String]
    type SkillGroupDescription =
      zio.aws.alexaforbusiness.model.primitives.SkillGroupDescription.Type
    object SkillGroupName extends Subtype[String]
    type SkillGroupName =
      zio.aws.alexaforbusiness.model.primitives.SkillGroupName.Type
    object SkillId extends Subtype[String]
    type SkillId = zio.aws.alexaforbusiness.model.primitives.SkillId.Type
    object SkillListMaxResults extends Subtype[Int]
    type SkillListMaxResults =
      zio.aws.alexaforbusiness.model.primitives.SkillListMaxResults.Type
    object SkillName extends Subtype[String]
    type SkillName = zio.aws.alexaforbusiness.model.primitives.SkillName.Type
    object SkillStoreType extends Subtype[String]
    type SkillStoreType =
      zio.aws.alexaforbusiness.model.primitives.SkillStoreType.Type
    object SoftwareVersion extends Subtype[String]
    type SoftwareVersion =
      zio.aws.alexaforbusiness.model.primitives.SoftwareVersion.Type
    object SortKey extends Subtype[String]
    type SortKey = zio.aws.alexaforbusiness.model.primitives.SortKey.Type
    object SsmlValue extends Subtype[String]
    type SsmlValue = zio.aws.alexaforbusiness.model.primitives.SsmlValue.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.alexaforbusiness.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.alexaforbusiness.model.primitives.TagValue.Type
    object TextValue extends Subtype[String]
    type TextValue = zio.aws.alexaforbusiness.model.primitives.TextValue.Type
    object TimeToLiveInSeconds extends Subtype[Int]
    type TimeToLiveInSeconds =
      zio.aws.alexaforbusiness.model.primitives.TimeToLiveInSeconds.Type
    object Timezone extends Subtype[String]
    type Timezone = zio.aws.alexaforbusiness.model.primitives.Timezone.Type
    object TotalCount extends Subtype[Int]
    type TotalCount = zio.aws.alexaforbusiness.model.primitives.TotalCount.Type
    object TrustAnchor extends Subtype[String]
    type TrustAnchor =
      zio.aws.alexaforbusiness.model.primitives.TrustAnchor.Type
    object Url extends Subtype[String]
    type Url = zio.aws.alexaforbusiness.model.primitives.Url.Type
    object UserCode extends Subtype[String]
    type UserCode = zio.aws.alexaforbusiness.model.primitives.UserCode.Type
    object UserId extends Subtype[String]
    type UserId = zio.aws.alexaforbusiness.model.primitives.UserId.Type
    object User_FirstName extends Subtype[String]
    type User_FirstName =
      zio.aws.alexaforbusiness.model.primitives.User_FirstName.Type
    object User_LastName extends Subtype[String]
    type User_LastName =
      zio.aws.alexaforbusiness.model.primitives.User_LastName.Type
    object User_UserId extends Subtype[String]
    type User_UserId =
      zio.aws.alexaforbusiness.model.primitives.User_UserId.Type
    object Utterance extends Subtype[String]
    type Utterance = zio.aws.alexaforbusiness.model.primitives.Utterance.Type
    object Value extends Subtype[String]
    type Value = zio.aws.alexaforbusiness.model.primitives.Value.Type
  }
  type AddressBookDataList =
    List[zio.aws.alexaforbusiness.model.AddressBookData]
  type AudioList = List[zio.aws.alexaforbusiness.model.Audio]
  type AuthorizationResult = Map[Key, Value]
  type BulletPoints = List[BulletPoint]
  type BusinessReportScheduleList =
    List[zio.aws.alexaforbusiness.model.BusinessReportSchedule]
  type CategoryList = List[zio.aws.alexaforbusiness.model.Category]
  type ConferenceProvidersList =
    List[zio.aws.alexaforbusiness.model.ConferenceProvider]
  type ContactDataList = List[zio.aws.alexaforbusiness.model.ContactData]
  type DeviceDataList = List[zio.aws.alexaforbusiness.model.DeviceData]
  type DeviceEventList = List[zio.aws.alexaforbusiness.model.DeviceEvent]
  type DeviceStatusDetails =
    List[zio.aws.alexaforbusiness.model.DeviceStatusDetail]
  type EndOfMeetingReminderMinutesList = List[Minutes]
  type Features = List[zio.aws.alexaforbusiness.model.Feature]
  type FilterList = List[zio.aws.alexaforbusiness.model.Filter]
  type FilterValueList = List[FilterValue]
  type GatewayGroupSummaries =
    List[zio.aws.alexaforbusiness.model.GatewayGroupSummary]
  type GatewaySummaries = List[zio.aws.alexaforbusiness.model.GatewaySummary]
  type GenericKeywords = List[GenericKeyword]
  type NetworkProfileDataList =
    List[zio.aws.alexaforbusiness.model.NetworkProfileData]
  type NewInThisVersionBulletPoints = List[BulletPoint]
  type PhoneNumberList = List[zio.aws.alexaforbusiness.model.PhoneNumber]
  type ProfileDataList = List[zio.aws.alexaforbusiness.model.ProfileData]
  type Reviews = Map[ReviewKey, ReviewValue]
  type RoomDataList = List[zio.aws.alexaforbusiness.model.RoomData]
  type RoomSkillParameters =
    List[zio.aws.alexaforbusiness.model.RoomSkillParameter]
  type SampleUtterances = List[Utterance]
  type ShortSkillIdList = List[SkillId]
  type SipAddressList = List[zio.aws.alexaforbusiness.model.SipAddress]
  type SkillGroupDataList = List[zio.aws.alexaforbusiness.model.SkillGroupData]
  type SkillSummaryList = List[zio.aws.alexaforbusiness.model.SkillSummary]
  type SkillTypes = List[SkillStoreType]
  type SkillsStoreSkillList =
    List[zio.aws.alexaforbusiness.model.SkillsStoreSkill]
  type SmartHomeApplianceList =
    List[zio.aws.alexaforbusiness.model.SmartHomeAppliance]
  type SortList = List[zio.aws.alexaforbusiness.model.Sort]
  type SsmlList = List[zio.aws.alexaforbusiness.model.Ssml]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.alexaforbusiness.model.Tag]
  type TextList = List[zio.aws.alexaforbusiness.model.Text]
  type TrustAnchorList = List[TrustAnchor]
  type UserDataList = List[zio.aws.alexaforbusiness.model.UserData]
}
