package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  SkillGroupDescription,
  SkillGroupName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SkillGroup(
    skillGroupArn: Optional[Arn] = Optional.Absent,
    skillGroupName: Optional[SkillGroupName] = Optional.Absent,
    description: Optional[SkillGroupDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SkillGroup = {
    import SkillGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SkillGroup
      .builder()
      .optionallyWith(
        skillGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.skillGroupArn)
      .optionallyWith(
        skillGroupName.map(value =>
          SkillGroupName.unwrap(value): java.lang.String
        )
      )(_.skillGroupName)
      .optionallyWith(
        description.map(value =>
          SkillGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SkillGroup.ReadOnly =
    zio.aws.alexaforbusiness.model.SkillGroup.wrap(buildAwsValue())
}
object SkillGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SkillGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SkillGroup =
      zio.aws.alexaforbusiness.model.SkillGroup(
        skillGroupArn.map(value => value),
        skillGroupName.map(value => value),
        description.map(value => value)
      )
    def skillGroupArn: Optional[Arn]
    def skillGroupName: Optional[SkillGroupName]
    def description: Optional[SkillGroupDescription]
    def getSkillGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("skillGroupArn", skillGroupArn)
    def getSkillGroupName: ZIO[Any, AwsError, SkillGroupName] =
      AwsError.unwrapOptionField("skillGroupName", skillGroupName)
    def getDescription: ZIO[Any, AwsError, SkillGroupDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillGroup
  ) extends zio.aws.alexaforbusiness.model.SkillGroup.ReadOnly {
    override val skillGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.skillGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val skillGroupName: Optional[SkillGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skillGroupName())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.SkillGroupName(value)
        )
    override val description: Optional[SkillGroupDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.SkillGroupDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillGroup
  ): zio.aws.alexaforbusiness.model.SkillGroup.ReadOnly = new Wrapper(impl)
}
